#ifdef J_DEBUG
#include <iostream.h>
#endif

#include "JCursor.h"


JCursor::JCursor()
  :_beat(0),
   _pitch(60),
   _visible(true),
   _damaged(true)
{
  //  assert(_the==0);
  // _the=this;
}

// JCursor *
// JCursor::the()
// { 
//   if (_the == 0) _the=new JCursor();
//   return _the;
// }

JCursor::~JCursor()
{
  //  _the=0;
}


void  
JCursor::setPitch(int pitch)
{ 
  _pitch = (pitch)%128;
  _damaged = true ;
}

void  
JCursor::setBeat(const JBeat &beat)
{

#ifdef J_DEBUG
  cout << "JCursor::setBeat() at " << beat <<endl;
#endif

  _beat=beat;
  if ( _beat < JBeat::startOfTime())
    _beat=JBeat::startOfTime();

  _damaged = true;
}




void 
JCursor::update()
{
  if (_damaged)
    notifyObservers(this);
  _damaged = false;
}



void 
JCursor::incPitch()
{
 _pitch = (++_pitch)%128; 
 _damaged=true;
}


void 
JCursor::decPitch()
{
  _pitch = (--_pitch+256)%128; 

  _damaged=true;

}


void 
JCursor::moveRightBy(const JDuration &duration)
{
  _beat += duration ; 
  if ( _beat < JBeat::startOfTime())
    _beat=JBeat::startOfTime();

  _damaged = true;

}

void 
JCursor::moveLeftBy(const JDuration &duration)
{
  _beat -= duration ; 
  if ( _beat < JBeat::startOfTime())
    _beat=JBeat::startOfTime();

  _damaged = true;

}













