IMPLEMENTATION MODULE IOErrorCodes;

	(********************************************************)
	(*							*)
	(*		I/O subsystem error codes.		*)
	(*							*)
	(*  This module provides operations on the file system	*)
	(*			error codes.			*)
	(*							*)
	(*  Programmer:		P. Moylan			*)
	(*  Last edited:	18 July 1993			*)
	(*  Status:		OK				*)
	(*							*)
	(********************************************************)

FROM Windows IMPORT
    (* proc *)	WriteString;

FROM NumericIO IMPORT
    (* proc *)	WriteCard;

(************************************************************************)

PROCEDURE WriteErrorCode (w: Window;  code: ErrorCode);

    (* Puts out the error code in readable form. *)

    BEGIN
	CASE code OF
	    OK:			WriteString (w, "OK");
	  |
	    OperationAborted:	WriteString (w, "OperationAborted");
	  |
	    FileNotOpen:	WriteString (w, "FileNotOpen");
	  |
	    NoSuchDevice:	WriteString (w, "NoSuchDevice");
	  |
	    NoSuchUnit:		WriteString (w, "NoSuchUnit");
	  |
	    FeatureNotImplemented: WriteString (w, "FeatureNotImplemented");
	  |
	    InvalidFileNameString: WriteString (w, "InvalidFileNameString");
	  |
	    DirectoryNotFound:	WriteString (w, "DirectoryNotFound");
	  |
	    NotADirectory:	WriteString (w, "NotADirectory");
	  |
	    NameNotFound:	WriteString (w, "NameNotFound");
	  |
	    DuplicateFileName:	WriteString (w, "DuplicateFileName");
	  |
	    DeviceFull:		WriteString (w, "DeviceFull");
	  |
	    DirectoryFull:	WriteString (w, "DirectoryFull");
	  |
	    BadDMAAddress:	WriteString (w, "BadDMAAddress");
	  |
	    IllegalBlockNumber:	WriteString (w, "IllegalBlockNumber");
	  |
	    BadCommand:		WriteString (w, "BadCommand");
	  |
	    ControllerNotListening: WriteString (w, "ControllerNotListening");
	  |
	    ControllerOutOfSync: WriteString (w, "ControllerOutOfSync");
	  |
	    TimeoutError:	WriteString (w, "TimeoutError");
	  |
	    CalibrationFailure:	WriteString (w, "CalibrationFailure");
	  |
	    SeekFailure:	WriteString (w, "SeekFailure");
	  |
	    DriveNotReady:	WriteString (w, "DriveNotReady");
	  |
	    SectorNotFound:	WriteString (w, "SectorNotFound");
	  |
	    BadBlock:		WriteString (w, "BadBlock");
	  |
	    BadData:		WriteString (w, "BadData");
	  |
	    WriteFault:		WriteString (w, "WriteFault");
	  |
	    WriteProtected:	WriteString (w, "WriteProtected");
	  |
	    UndiagnosedFailure:	WriteString (w, "UndiagnosedFailure");
	  |
	  ELSE
		WriteString (w, "Unknown error code ");
		WriteCard (w, ORD(code));
	END (*CASE*);
    END WriteErrorCode;

END IOErrorCodes.
