MODULE M3D02;

	(********************************************************)
	(*							*)
	(*		Test of module Music3.			*)
	(*							*)
	(*	     J.S. Bach: Minuet from the			*)
	(*	 "Notenbuch vor Anna Magdalena Bach"		*)
	(*							*)
	(*  Programmer:		P. Moylan			*)
	(*  Last edited:	9 May 1993			*)
	(*  Status:		OK				*)
	(*							*)
	(********************************************************)

FROM Music3 IMPORT
    (* proc *)	Voice1, Voice2, SetInitialDuration, PlayTheMusic;

(************************************************************************)

PROCEDURE EncodeMusic;

    (* Plays a piece of music. *)

    BEGIN	(* EncodeMusic *)

	(************************)
	(* J.S. Bach, Minuet	*)
	(************************)

	Voice1 ("D/dGABC*DdGG uE/CDEF#*GdGG");
	Voice1 ("C/DCBA*B/CBAG *F#/GABG*AAA");
	Voice1 ("D/dGABC*DdGG uE/CDEF#*GdGG");
	Voice1 ("C/DCBA*B/CBAG *A/BAGF#*GGGu");

	Voice2 ("dd");
	Voice2 ("*G/ABBB CCCBBB");
	Voice2 ("AAAGGG uDdGGuD/DCBA");
	Voice2 ("*BBAGBG CCCB/CBAG");
	Voice2 ("*AAF#GGB CDDdGuDdG");

	(* Repeat of the first part. *)

	Voice1 ("D/dGABC*DdGG uE/CDEF#*GdGG");
	Voice1 ("C/DCBA*B/CBAG *F#/GABG*AAA");
	Voice1 ("D/dGABC*DdGG uE/CDEF#*GdGG");
	Voice1 ("C/DCBA*B/CBAG *A/BAGF#*GGGu");

	Voice2 ("*G/ABBB CCCBBB");
	Voice2 ("AAAGGG uDdGGuD/DCBA");
	Voice2 ("*BBAGBG CCCB/CBAG");
	Voice2 ("*AAF#GGB CDDdGuDdG");

	(* Page 2. *)

	Voice1 ("B/GABG*A/dDEF#D *G/EF#GD*C#/BC#*A");
	Voice1 ("/ABC#DEF#*GF#E F#dAC#DDD");
	Voice1 ("D/dGF#*GuE/dGF#*G uDCB/AGF#G*A");
	Voice1 ("/dDEF#GAB*CBA /BD*dGF#GGGu");

	Voice2 ("uGDGF#AdD EGEAdAuA");
	Voice2 ("dAuAdABDC# DdF#ADDC");
	Voice2 ("BBBCCC BAGuDRRd");
	Voice2 ("RRF#EGF# GBDdGuDdG");

	(* Repeat of the second part. *)

	Voice1 ("B/GABG*A/dDEF#D *G/EF#GD*C#/BC#*A");
	Voice1 ("/ABC#DEF#*GF#E F#dAC#DDD");
	Voice1 ("D/dGF#*GuE/dGF#*G uDCB/AGF#G*A");
	Voice1 ("/dDEF#GAB*CBA /BD*dGF#GGGu");

	Voice2 ("uGDGF#AdD EGEAdAuA");
	Voice2 ("dAuAdABDC# DdF#ADDC");
	Voice2 ("BBBCCC BAGuDRRd");
	Voice2 ("RRF#EGF# GBDdGuDdG");

    END EncodeMusic;

(************************************************************************)

BEGIN
    EncodeMusic;
    SetInitialDuration (280);
    PlayTheMusic;
END M3D02.
