/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include <stdio.h>
#include <termio.h>

static struct termio OldTTYIO;
static short os_set=0;

void echo_on(void)
{
	if(os_set)
	{
		ioctl(0,TCSETA,&OldTTYIO);
	}
}

void echo_off(void)
{
	if(!os_set)
	{
		os_set=1;
		ioctl(0,TCGETA,&OldTTYIO);
	}
	if(os_set)
	{
		struct termio temp2;
		ioctl(0,TCGETA,&temp2);
		temp2.c_lflag&=~ICANON;
		temp2.c_lflag&=~ECHO;
		temp2.c_cc[VEOF]=1;
		temp2.c_cc[VEOL]=0;
		ioctl(0,TCSETA,&temp2);
	}
}
