
typedef struct __cmd
{
	char *Command;	/* Command Name */
	unsigned int Rights;	/* Rights needed to see command */
	unsigned int Args;	/* Minimum valid arguments */
	char *ArgError;	/* Argument error message */
	char *Desc;	/* Command description message */
	void (*Function)(const struct __cmd *, int, char *[]);	/* Function to call */
} CommandList;

extern int ParseLine(char *, char *[]);
extern int BoolOpt(const char *);
extern int DoCommand(char *, const CommandList *);
extern void InitParser(void);

#define MAX_ARGC	32

extern void c_addfol(CommandList *cm, int argc, char **argv);
extern void c_autosub(CommandList *cm, int argc, char **argv);
extern void c_beep(CommandList *cm, int argc, char **argv);
extern void c_board(CommandList *cm, int argc, char **argv);
extern void c_cd(CommandList *cm, int argc, char **argv);
extern void c_catchup(CommandList *cm, int argc, char **argv);
extern void c_credits(CommandList *cm, int argc, char **argv);
extern void c_date(CommandList *cm, int argc, char **argv);
extern void c_doing(CommandList *cm, int argc, char **argv);
extern void c_first(CommandList *cm, int argc, char **argv);
extern void c_folder(CommandList *cm, int argc, char **argv);
extern void c_help(CommandList *cm, int argc, char **argv);
extern void c_inform(CommandList *cm, int argc, char **argv);
extern void c_last(CommandList *cm, int argc, char **argv);
extern void c_latest(CommandList *cm, int argc, char **argv);
extern void c_listall(CommandList *cm, int argc, char **argv);
extern void c_listnew(CommandList *cm, int argc, char **argv);
extern void c_listusers(CommandList *cm, int argc, char **argv);
extern void c_ls(CommandList *cm, int argc, char **argv);
extern void c_mesg(CommandList *cm, int argc, char **argv);
extern void c_mod(CommandList *cm, int argc, char **argv);
extern void c_msg(CommandList *cm, int argc, char **argv);
extern void c_new(CommandList *cm, int argc, char **argv);
extern void c_newusers(CommandList *cm, int argc, char **argv);
extern void c_passwd(CommandList *cm, int argc, char **argv);
extern void c_next(CommandList *cm, int argc, char **argv);
extern void c_pwd(CommandList *cm, int argc, char **argv);
extern void c_prev(CommandList *cm, int argc, char **argv);
extern void c_read(CommandList *cm, int argc, char **argv);
extern void c_reply(CommandList *cm, int argc, char **argv);
extern void c_resub(CommandList *cm, int argc, char **argv);
extern void c_search(CommandList *cm, int argc, char **argv);
extern void c_since(CommandList *cm, int argc, char **argv);
extern void c_status(CommandList *cm, int argc, char **argv);
extern void c_su(CommandList *cm, int argc, char **argv);
extern void c_tell(CommandList *cm, int argc, char **argv);
extern void c_topten(CommandList *cm, int argc, char **argv);
extern void c_unsub(CommandList *cm, int argc, char **argv);
extern void c_user(CommandList *cm, int argc, char **argv);
extern void c_who(CommandList *cm, int argc, char **argv);
extern void c_wall(CommandList *cm, int argc, char **argv);
extern void c_wiz(CommandList *cm, int argc, char **argv);
extern void c_wizchat(CommandList *cm, int argc, char **argv);
extern void c_write(CommandList *cm, int argc, char **argv);
extern void c_quit(CommandList *cm, int argc, char **argv);
extern void c_save(CommandList *cm, int argc, char **argv);
