/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
**** Changelog: ***************************************************************
Wed Dec  1 00:22:39  1993	initial version
Fri Dec  3 18:22:05  1993	seems to work perfectly
*/

/* 	the following type defines where an option is allowed and if it is
	mandatory */
	
typedef enum 
	{	VCONF_LOCAL = 1,	/* in local file allowed */
		VCONF_GLOBAL = 2,	/* in global file allowed */
		VCONF_CLINE = 4,	/* on command_line allowed */
		VCONF_MANDATORY = 8	/* is necessary */
	} vconf_type;

/*	the following struct defines the option
	It is used to pass this information to the vconf_parse() and
	is also used by it to store the values of the options.
*/
typedef struct
	{	char 		*string;	/* long name for config file */
		char		*clstring;	/* letter for command line */
		vconf_type	type;		/* global/local/command line */
		vconf_type	set;		/* where set? */
		char 		*value;		/* for storage of value */
	} vconf_parameter;

typedef void *VCONF_ERRFNCT(char *mesg);

/******************************************************************************/

/* this variable determines where to look for the global configuration file */

extern char vconf_global_prefix[PATH_MAX];	/* preset to:  "/usr/local/lib/" */

/******************************************************************************/

/*
**      This routine parses the files and the commandline
**      and returns 0 on success or an error code.
*/

extern
int	vconfig(char	*filename,		/* name of conffile without . */                vconf_parameter *vc_parm,       /* ptr to array of defs */
		int	*argc,			/* as usual */
		char	***argv,
		VCONF_ERRFNCT	*errfnct);	/* function to print errormsg */
						/* or NULL to ignore */
/* returncode:
**	VCONF_LOCAL, ... etc set, if error occured, 0 on success 
*/
