/**********************************************************************/
/*   Code  to  decode  PC keyboard scan codes as returned by Wyse-60  */
/*   terminal  in  PC  mode.  This code is not finished and unless I  */
/*   can  think  of  a good reason it never will be. This is because  */
/*   switching  to  and  from  PC scan code mode is too slow to make  */
/*   it worth using (about 2-3 seconds delay).			      */
/**********************************************************************/

# include "list.h"
# include	"alt.h"
# define WYSE
# if	defined(WYSE)
unsigned char wy_norm[] = {
/* 00 */0x00, 0x00, '1',  '2',  '3',  '4',  '5',  '6', 
	'7',  '8',  '9',  '-',  '=',  0x00, '\b', 0x00,
/* 10 */'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
	'o',  'p',  '[',  ']',  '\n', 0x00, 'a',  's',
/* 20 */'d',  'f',  'g',  'h',  'j',  'k',  'l',  ';',
	0x00, 0x00, 0x00, 0x00, 'z',  'x',  'c',  'v', 
/* 30 */'b',  'n',  'm',  ',',  '.',  '/', 0x00, 0x00,
	0x00, 0x00, 0x00, F(1), F(2), F(3), F(4), F(5),
/* 40 */F(6), F(7), F(8), F(9), F(10),0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 50 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 60 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 70 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	};
unsigned char wy_s[] = {
/* 00 */0x00, 0x00, '!',  '@',  '#',  '$',  '%',  '^', 
	'&',  '*',  '(',  ')',  '_',  0x00, 0x7f, 0x00,
/* 10 */'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
	'O',  'P',  '{',  '}',  '\n', 0x00, 'A',  'S',
/* 20 */'D',  'F',  'G',  'H',  'J',  'K',  'L',  ':',
	0x00, 0x00, 0x00, 0x00, 'Z',  'X',  'C',  'V',
/* 30 */'B',  'N',  'M',  '<',  '>',  '?',  0x00, 0x00,
	0x00, 0x00, 0x00, SF(1),SF(2),SF(3),SF(4),SF(5),
/* 40 */SF(6),SF(7),SF(8),SF(9),SF(10),0x00,0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 50 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 60 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 70 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	};
unsigned char wy_a[] = {
/* 00 */0x00, 0x00, '!',  '@',  '#',  '$',  '%',  '^', 
	'&',  '*',  '(',  ')',  '_',  0x00, '\b', 0x00,
/* 10 */ALT_Q,  ALT_W,  ALT_E,  ALT_R,  ALT_T,  ALT_Y,  ALT_U,  ALT_I,
	ALT_O,  ALT_P,  '{',  '}',  '\n', 0x00, ALT_A,  ALT_S,
/* 20 */ALT_D,  ALT_F,  ALT_G,  ALT_H,  ALT_J,  ALT_K,  ALT_L,  ':',
	0x00, 0x00, 0x00, 0x00, ALT_Z,  ALT_X,  ALT_C,  ALT_V,
/* 30 */ALT_B,  ALT_N,  ALT_M,  '<',  '>',  '?',  0x00, 0x00,
	0x00, 0x00, 0x00, AF(1),AF(2),AF(3),AF(4),AF(5),
/* 40 */AF(6),AF(7),AF(8),AF(9),AF(10),0x00,0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 50 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 60 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 70 */0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	};
unsigned char wy_sc[] = {
	0
	};
unsigned char wy_c[] = {
	0
	};
unsigned char wy_as[] = {
	0
	};
unsigned char wy_ac[] = {
	0
	};
unsigned char wy_acs[] = {
	0
	};
unsigned char *wy_ptr = wy_norm;
int	wy_state = 0;
int	wy_shift = 0;
int	wy_shift2 = 0;

# define	ST_NORMAL	0
# define	ST_S		0x01
# define	ST_C		0x02
# define	ST_A		0x04

# define	ST_SL		0x01
# define	ST_SR		0x02

unsigned char	*wy_maps[] = {
	wy_norm,
	wy_s,
	wy_c,
	wy_sc,
	wy_a,
	wy_as,
	wy_ac,
	wy_acs
	};

# define	WY_ALT	0x38
# define	WY_RSH	0x36
# define	WY_CTRL	0x1d
# define	WY_LSH	0x2a
# define	WY_CAPS	0x3a
scode_read()
{	int	ch, ch1;
	unsigned char buf[1];
	int	s, i;

	while (1) {
		i = read(0, buf, 1);
		if (i != 1)
			return i;
		ch = buf[0];
		switch (ch & 0x7f) {
		  case WY_RSH:
		  case WY_LSH:
			switch (ch) {
			  case WY_RSH | 0x80:
				wy_shift2 &= ~ST_SR;
				if (wy_shift2 & ST_SL)
					continue;
				break;
			  case WY_LSH | 0x80:
				wy_shift2 &= ~ST_SL;
				if (wy_shift2 & ST_SR)
					continue;
				break;
			  case WY_RSH:
				wy_shift2 |= ST_SR;
				if (wy_shift2 & ST_SL)
					continue;
				break;
			  case WY_LSH:
				wy_shift2 |= ST_SL;
				if (wy_shift2 & ST_SR)
					continue;
				break;
			  }
			s = ST_S;
			break;
		  case WY_ALT:
			s = ST_A;
			break;
		  case WY_CTRL:
			s = ST_C;
			break;
		  case WY_CAPS:
			continue;
		  default:
			s = 0;
			break;
		  }
		if (s) {
			if (ch & 0x80)
				wy_state &= ~s;
			else
				wy_state |= s;
			wy_ptr = wy_maps[wy_state];
			continue;
			}
		if (ch & 0x80)
			continue;
		ch1 = wy_ptr[ch];
		return ch1;
		}
}
# else
scode_read()
{
}
# endif
