/**********************************************************************/
/*   This  function  can  read a backslash newline continued line of  */
/*   arbritrary  length.  It  dynamically  allocates  memory for the  */
/*   line so we have no upper limit on the line size.		      */
/**********************************************************************/

# include	<stdio.h>
# include	<memory.h>
# include	<malloc.h>

/**********************************************************************/
/*   Initial size of line.					      */
/**********************************************************************/
# define	INIT_LINE_SIZE	1024

/**********************************************************************/
/*   Increment each time we run out of memory.			      */
/**********************************************************************/
# define	LINE_INCR	1024

static char	*lptr;	/* Pointer to currently allocated block.	*/
static int	lsize;	/* Size currently allocated.			*/

char *
read_backslash_line(fp, line_no)
FILE	*fp;
int	*line_no;
{
	int	index;
	int	len;
	char	*cp;
	
	index = 0;
	while (1) {
		if (index >= lsize - 1) {
			if (lptr == NULL) {
				lsize = INIT_LINE_SIZE;
				lptr = malloc(INIT_LINE_SIZE);
				}
			else {
				lsize += LINE_INCR;
				lptr = realloc(lptr, lsize);
				}
			}
		if (fgets(&lptr[index], lsize - index - 1, fp) == NULL)
			return NULL;
		len = strlen(lptr + index) + index;
		cp = &lptr[len-1];
		if (cp > lptr && cp[-1] == '\\' && cp[0] == '\n') {
			len -= 2;
			cp[-1] = NULL;
			(*line_no)++;
			}
		else if (*cp != '\n')
			;
		else {
			(*line_no)++;
			return lptr;
			}
		index = len;
		}
}
