#include<stdio.h>
#include<math.h>

#define LPR "lpr "
#define NOTHING 0
#define ORBIT 1
#define DFIELD 2

typedef struct dfobj{
  struct dfobj *next;
  int type,active,mode,n;
  float *data;
} dfobj;

extern dfobj *dfobjs;
extern float oxmin, oxmax, oymin, oymax;
extern int xgrid, ygrid;
extern char help[128];

int psheight, pswidth;
float ps_xscale_factor, ps_yscale_factor;
char *getenv();

/***************************************************************/
extern char output_file[];

show_ps_graphics(printer) int printer;
{
  FILE *fp, *fopen();

  if(dfobjs == (dfobj *)0)
    int_error("Nothing to send to the printer", -1);
  /*
   * check printer !
   */
  ps_set_scale_factor();
  if( output_file[0] == '\0')
    (void)sprintf(output_file,"/tmp/df%d.ps",getpid()); 
  if( (fp=fopen(output_file,"w")) == (FILE *)NULL)
    os_error("cannot open tmp file",-1);
  (void)fprintf(fp,"%%!PS-Adobe-2.0\n%%% Creator: dfplot\n");
  (void)fprintf(fp,"%%%%BoundingBox: 90 190 522 622\n");

  (void)fprintf(fp,"/dfpsdict 5 dict def\n");
  (void)fprintf(fp,"dfpsdict begin\n");
  (void)fprintf(fp,"/M {moveto} bind def\n");
  (void)fprintf(fp,"/L {lineto} bind def\n");
  (void)fprintf(fp,"/Vshow { currentpoint stroke M\n");
  (void)fprintf(fp,"dup stringwidth pop neg -46 rmoveto show } def\n");
  (void)fprintf(fp,"/Hshow { currentpoint stroke M\n");
  (void)fprintf(fp,"dup stringwidth pop -2 div -46 rmoveto show } def\n");
  (void)fprintf(fp,"/Cshow { currentpoint stroke M\n");
  (void)fprintf(fp,"dup stringwidth pop -2 div -46 rmoveto show } def\n");
  (void)fprintf(fp,"end\n");

  (void)fprintf(fp,"\n\ndfpsdict begin\ngsave\n");
  (void)fprintf(fp,"90 190 translate\n");
  (void)fprintf(fp,"0.1 0.1 scale\n");
  (void)fprintf(fp,"1 setlinewidth\n");
  ps_plot_ode(fp);
  ps_tic_marks(fp);
  ps_text(fp);
  (void)fprintf(fp,"stroke\ngrestore\nend\nshowpage\n");
  fflush(fp);
  fclose(fp);
  if(printer) send_to_printer();
}
ps_plot_ode(fp) FILE *fp;
{
  int i, j, count, psx,psy;
  dfobj *tmp = dfobjs;
  float *data;

  while(tmp)
    {
      if(tmp->mode == ORBIT)
	{
	  data = tmp->data;
	  count = 0;
	  ps_world_2_screen(data[0],data[1], &psx,&psy);
	  (void)fprintf(fp,"newpath\n");
	  (void)fprintf(fp,"%d %d  M\n",psx,psy);
	  for(i = 2; i < tmp->n -2; i += 2)
	    {
	      ps_world_2_screen(data[i],data[i+1], &psx,&psy); 
	      (void)fprintf(fp,"%d %d  L\n",psx,psy); 
	      count++;
	      if(count > 256)
		{
		  (void)fprintf(fp,"stroke\n"); (void)fprintf(fp,"newpath\n");
		  (void)fprintf(fp,"%d %d  M\n",psx,psy);	
		  count = 0;
		}
	    }
	  (void)fprintf(fp,"stroke\n");
	}
      else if(tmp->mode == DFIELD)
	    {
	      float xdif, ydif,x,y,u,v,xx,yy,uu,vv; int k, psxa,psya;
	      xdif = (oxmax - oxmin)/xgrid;
	      ydif = (oymax - oymin)/ygrid;
	      data = tmp->data;
	      x = xdif;
	      for(i = 0; i< xgrid -1; i++)
		{
		  y = ydif;
		  for(j = 0; j < ygrid -1; j++)
		    {
		      k = 2*(i*(ygrid -1) + j);
		      u = data[k]; v = data[k+1];
		      uu = 0.775 *u; vv = 0.775*v;
		      xx = -0.1 *v; yy = 0.1*u;
		      u=x+u; v= y+v;
		      ps_world_2_screen(u,v,&psxa,&psya);
		      ps_world_2_screen(x,y,&psx,&psy);
		      (void)fprintf(fp,"%d %d M\n",psx,psy);
		      (void)fprintf(fp,"%d %d L\n",psxa,psya);
		      ps_world_2_screen(x+uu+xx,y+vv+yy,&psx,&psy);
		      (void)fprintf(fp,"%d %d M\n",psx,psy);
		      (void)fprintf(fp,"%d %d L\n",psxa,psya);
		      ps_world_2_screen(x+uu-xx,y+vv-yy,&psx,&psy);
		      (void)fprintf(fp,"%d %d L\n",psx,psy);
		      y += ydif;
		    }
		  (void)fprintf(fp,"stroke\n");
		  x += xdif;
		}
	    }
      tmp = tmp->next;
    }
}
/***************************************************************/

ps_set_scale_factor()
{
  pswidth=4320; psheight=4320;
  ps_xscale_factor = (float) (pswidth)/(oxmax -oxmin);
  ps_yscale_factor = (float) (psheight)/(oymax -oymin);
}

ps_world_2_screen(wx,wy,sx,sy)
     float wx, wy; int *sx, *sy;
{
  *sx = (int) ( ps_xscale_factor * wx);
  *sy = (int) ( ps_yscale_factor * wy);
}

ps_tic_marks(fp) FILE *fp;
{
  int i, unit,x,y;
  (void)fprintf(fp,"newpath\n",x,y);
  unit = pswidth/32;
  y = 0; x = unit;
  for(i = 1; i < 32; i++)
    {
      (void)fprintf(fp,"%d %d M\n",x,y);
      (void)fprintf(fp,"%d %d L\n",x,y+35);
      x += unit;
    }
  unit *= 4; x= unit;
  for(i=1; i<8; i++)
    {
      (void)fprintf(fp,"%d %d M\n",x,y);
      (void)fprintf(fp,"%d %d L\n",x,y+70);
      x += unit;
    }
  unit = psheight/32;
  x = 0; y = unit;
  for(i=1; i<32; i++)
    {
      (void)fprintf(fp,"%d %d M\n",x,y);
      (void)fprintf(fp,"%d %d L\n",x+35,y);
      y += unit;
    }
  unit *= 4; y=unit; 
  for(i=1; i< 8; i++)
    {
      (void)fprintf(fp,"%d %d M\n",x,y);
      (void)fprintf(fp,"%d %d L\n",x+70,y);
      y += unit;
    }
  (void)fprintf(fp,"0 0 M\n");  
  (void)fprintf(fp,"%d %d L\n",pswidth,0);
  (void)fprintf(fp,"%d %d L\n",pswidth,psheight);
  (void)fprintf(fp,"%d %d L\n",0,psheight);
  (void)fprintf(fp,"%d %d L\n",0,0);
  (void)fprintf(fp,"stroke\n");  
}
/*******************************************************************/
ps_text(fp) FILE *fp;
{
  extern char *odetitle;
  int p, i, unit;
  float dim; 
  char *s = odetitle;
  unit = pswidth/4;
  dim = oxmax - oxmin;

  (void)fprintf(fp,"/Helvetica findfont 100 scalefont setfont\n");
  (void)fprintf(fp,"newpath\n");
  for(i=0; i<= 4; i++)
    {
      (void)fprintf(fp,"%d %d M\n",i*unit,-100);
      (void)fprintf(fp,"(%g) Hshow\n",(dim)/4.0 * (float)i + oxmin);
    }

  unit = psheight/4;
  dim = oymax - oymin;  
  for(i=0; i<= 4; i++)
    {
      (void)fprintf(fp,"%d %d M\n",-100,i*unit);
      (void)fprintf(fp,"(%g) Vshow\n",(dim)/4.0 * (float)i + oymin);
    }

  (void)fprintf(fp,"/Helvetica findfont 140 scalefont setfont\n");
  (void)fprintf(fp,"%d %d M\n",pswidth/2,psheight+120);
  (void)fprintf(fp,"(");
  while(*s != '\0')
    {
      if( (*s == '(') ) fprintf(fp,"\\(");
      else if( (*s == ')')) fprintf(fp,"\\)");
      else fprintf(fp,"%c",*s);
      s++;
    }
  (void)fprintf(fp,")  ");
  (void)fprintf(fp, "Cshow\n");
}
send_to_printer()
{
  char *s;

  strcpy(help, LPR);
  s = getenv("PRINTER");
  if(s)
    {
      strcat(help,"-P");
      strcat(help,s);  strcat(help," ");    
    }
  strcat(help, output_file);
  if(system(help))
    os_error("cannot send psfile to printer",-1);
}
