/***********************license start***************
 * Author: Cavium Networks
 *
 * Contact: support@caviumnetworks.com
 * This file is part of the OCTEON SDK
 *
 * Copyright (c) 2003-2008 Cavium Networks
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2, as
 * published by the Free Software Foundation.
 *
 * This file is distributed in the hope that it will be useful, but
 * AS-IS and WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, TITLE, or
 * NONINFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this file; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * or visit http://www.gnu.org/licenses/.
 *
 * This file may also be available under a different license from Cavium.
 * Contact Cavium Networks for more information
 ***********************license end**************************************/

#ifndef __CVMX_PCIEEP_DEFS_H__
#define __CVMX_PCIEEP_DEFS_H__

#define CVMX_PCIEEP_CFG000 \
	 (0x0000000000000000ull)
#define CVMX_PCIEEP_CFG001 \
	 (0x0000000000000004ull)
#define CVMX_PCIEEP_CFG002 \
	 (0x0000000000000008ull)
#define CVMX_PCIEEP_CFG003 \
	 (0x000000000000000Cull)
#define CVMX_PCIEEP_CFG004 \
	 (0x0000000000000010ull)
#define CVMX_PCIEEP_CFG004_MASK \
	 (0x0000000080000010ull)
#define CVMX_PCIEEP_CFG005 \
	 (0x0000000000000014ull)
#define CVMX_PCIEEP_CFG005_MASK \
	 (0x0000000080000014ull)
#define CVMX_PCIEEP_CFG006 \
	 (0x0000000000000018ull)
#define CVMX_PCIEEP_CFG006_MASK \
	 (0x0000000080000018ull)
#define CVMX_PCIEEP_CFG007 \
	 (0x000000000000001Cull)
#define CVMX_PCIEEP_CFG007_MASK \
	 (0x000000008000001Cull)
#define CVMX_PCIEEP_CFG008 \
	 (0x0000000000000020ull)
#define CVMX_PCIEEP_CFG008_MASK \
	 (0x0000000080000020ull)
#define CVMX_PCIEEP_CFG009 \
	 (0x0000000000000024ull)
#define CVMX_PCIEEP_CFG009_MASK \
	 (0x0000000080000024ull)
#define CVMX_PCIEEP_CFG010 \
	 (0x0000000000000028ull)
#define CVMX_PCIEEP_CFG011 \
	 (0x000000000000002Cull)
#define CVMX_PCIEEP_CFG012 \
	 (0x0000000000000030ull)
#define CVMX_PCIEEP_CFG012_MASK \
	 (0x0000000080000030ull)
#define CVMX_PCIEEP_CFG013 \
	 (0x0000000000000034ull)
#define CVMX_PCIEEP_CFG015 \
	 (0x000000000000003Cull)
#define CVMX_PCIEEP_CFG016 \
	 (0x0000000000000040ull)
#define CVMX_PCIEEP_CFG017 \
	 (0x0000000000000044ull)
#define CVMX_PCIEEP_CFG020 \
	 (0x0000000000000050ull)
#define CVMX_PCIEEP_CFG021 \
	 (0x0000000000000054ull)
#define CVMX_PCIEEP_CFG022 \
	 (0x0000000000000058ull)
#define CVMX_PCIEEP_CFG023 \
	 (0x000000000000005Cull)
#define CVMX_PCIEEP_CFG028 \
	 (0x0000000000000070ull)
#define CVMX_PCIEEP_CFG029 \
	 (0x0000000000000074ull)
#define CVMX_PCIEEP_CFG030 \
	 (0x0000000000000078ull)
#define CVMX_PCIEEP_CFG031 \
	 (0x000000000000007Cull)
#define CVMX_PCIEEP_CFG032 \
	 (0x0000000000000080ull)
#define CVMX_PCIEEP_CFG033 \
	 (0x0000000000000084ull)
#define CVMX_PCIEEP_CFG034 \
	 (0x0000000000000088ull)
#define CVMX_PCIEEP_CFG037 \
	 (0x0000000000000094ull)
#define CVMX_PCIEEP_CFG038 \
	 (0x0000000000000098ull)
#define CVMX_PCIEEP_CFG039 \
	 (0x000000000000009Cull)
#define CVMX_PCIEEP_CFG040 \
	 (0x00000000000000A0ull)
#define CVMX_PCIEEP_CFG041 \
	 (0x00000000000000A4ull)
#define CVMX_PCIEEP_CFG042 \
	 (0x00000000000000A8ull)
#define CVMX_PCIEEP_CFG064 \
	 (0x0000000000000100ull)
#define CVMX_PCIEEP_CFG065 \
	 (0x0000000000000104ull)
#define CVMX_PCIEEP_CFG066 \
	 (0x0000000000000108ull)
#define CVMX_PCIEEP_CFG067 \
	 (0x000000000000010Cull)
#define CVMX_PCIEEP_CFG068 \
	 (0x0000000000000110ull)
#define CVMX_PCIEEP_CFG069 \
	 (0x0000000000000114ull)
#define CVMX_PCIEEP_CFG070 \
	 (0x0000000000000118ull)
#define CVMX_PCIEEP_CFG071 \
	 (0x000000000000011Cull)
#define CVMX_PCIEEP_CFG072 \
	 (0x0000000000000120ull)
#define CVMX_PCIEEP_CFG073 \
	 (0x0000000000000124ull)
#define CVMX_PCIEEP_CFG074 \
	 (0x0000000000000128ull)
#define CVMX_PCIEEP_CFG448 \
	 (0x0000000000000700ull)
#define CVMX_PCIEEP_CFG449 \
	 (0x0000000000000704ull)
#define CVMX_PCIEEP_CFG450 \
	 (0x0000000000000708ull)
#define CVMX_PCIEEP_CFG451 \
	 (0x000000000000070Cull)
#define CVMX_PCIEEP_CFG452 \
	 (0x0000000000000710ull)
#define CVMX_PCIEEP_CFG453 \
	 (0x0000000000000714ull)
#define CVMX_PCIEEP_CFG454 \
	 (0x0000000000000718ull)
#define CVMX_PCIEEP_CFG455 \
	 (0x000000000000071Cull)
#define CVMX_PCIEEP_CFG456 \
	 (0x0000000000000720ull)
#define CVMX_PCIEEP_CFG458 \
	 (0x0000000000000728ull)
#define CVMX_PCIEEP_CFG459 \
	 (0x000000000000072Cull)
#define CVMX_PCIEEP_CFG460 \
	 (0x0000000000000730ull)
#define CVMX_PCIEEP_CFG461 \
	 (0x0000000000000734ull)
#define CVMX_PCIEEP_CFG462 \
	 (0x0000000000000738ull)
#define CVMX_PCIEEP_CFG463 \
	 (0x000000000000073Cull)
#define CVMX_PCIEEP_CFG464 \
	 (0x0000000000000740ull)
#define CVMX_PCIEEP_CFG465 \
	 (0x0000000000000744ull)
#define CVMX_PCIEEP_CFG466 \
	 (0x0000000000000748ull)
#define CVMX_PCIEEP_CFG467 \
	 (0x000000000000074Cull)
#define CVMX_PCIEEP_CFG468 \
	 (0x0000000000000750ull)
#define CVMX_PCIEEP_CFG490 \
	 (0x00000000000007A8ull)
#define CVMX_PCIEEP_CFG491 \
	 (0x00000000000007ACull)
#define CVMX_PCIEEP_CFG492 \
	 (0x00000000000007B0ull)
#define CVMX_PCIEEP_CFG516 \
	 (0x0000000000000810ull)
#define CVMX_PCIEEP_CFG517 \
	 (0x0000000000000814ull)

union cvmx_pcieep_cfg000 {
	uint32_t u32;
	struct cvmx_pcieep_cfg000_s {
		uint32_t devid:16;
		uint32_t vendid:16;
	} s;
	struct cvmx_pcieep_cfg000_s cn52xx;
	struct cvmx_pcieep_cfg000_s cn52xxp1;
	struct cvmx_pcieep_cfg000_s cn56xx;
	struct cvmx_pcieep_cfg000_s cn56xxp1;
};

union cvmx_pcieep_cfg001 {
	uint32_t u32;
	struct cvmx_pcieep_cfg001_s {
		uint32_t dpe:1;
		uint32_t sse:1;
		uint32_t rma:1;
		uint32_t rta:1;
		uint32_t sta:1;
		uint32_t devt:2;
		uint32_t mdpe:1;
		uint32_t fbb:1;
		uint32_t reserved_22_22:1;
		uint32_t m66:1;
		uint32_t cl:1;
		uint32_t i_stat:1;
		uint32_t reserved_11_18:8;
		uint32_t i_dis:1;
		uint32_t fbbe:1;
		uint32_t see:1;
		uint32_t ids_wcc:1;
		uint32_t per:1;
		uint32_t vps:1;
		uint32_t mwice:1;
		uint32_t scse:1;
		uint32_t me:1;
		uint32_t msae:1;
		uint32_t isae:1;
	} s;
	struct cvmx_pcieep_cfg001_s cn52xx;
	struct cvmx_pcieep_cfg001_s cn52xxp1;
	struct cvmx_pcieep_cfg001_s cn56xx;
	struct cvmx_pcieep_cfg001_s cn56xxp1;
};

union cvmx_pcieep_cfg002 {
	uint32_t u32;
	struct cvmx_pcieep_cfg002_s {
		uint32_t bcc:8;
		uint32_t sc:8;
		uint32_t pi:8;
		uint32_t rid:8;
	} s;
	struct cvmx_pcieep_cfg002_s cn52xx;
	struct cvmx_pcieep_cfg002_s cn52xxp1;
	struct cvmx_pcieep_cfg002_s cn56xx;
	struct cvmx_pcieep_cfg002_s cn56xxp1;
};

union cvmx_pcieep_cfg003 {
	uint32_t u32;
	struct cvmx_pcieep_cfg003_s {
		uint32_t bist:8;
		uint32_t mfd:1;
		uint32_t chf:7;
		uint32_t lt:8;
		uint32_t cls:8;
	} s;
	struct cvmx_pcieep_cfg003_s cn52xx;
	struct cvmx_pcieep_cfg003_s cn52xxp1;
	struct cvmx_pcieep_cfg003_s cn56xx;
	struct cvmx_pcieep_cfg003_s cn56xxp1;
};

union cvmx_pcieep_cfg004 {
	uint32_t u32;
	struct cvmx_pcieep_cfg004_s {
		uint32_t lbab:18;
		uint32_t reserved_4_13:10;
		uint32_t pf:1;
		uint32_t typ:2;
		uint32_t mspc:1;
	} s;
	struct cvmx_pcieep_cfg004_s cn52xx;
	struct cvmx_pcieep_cfg004_s cn52xxp1;
	struct cvmx_pcieep_cfg004_s cn56xx;
	struct cvmx_pcieep_cfg004_s cn56xxp1;
};

union cvmx_pcieep_cfg004_mask {
	uint32_t u32;
	struct cvmx_pcieep_cfg004_mask_s {
		uint32_t lmask:31;
		uint32_t enb:1;
	} s;
	struct cvmx_pcieep_cfg004_mask_s cn52xx;
	struct cvmx_pcieep_cfg004_mask_s cn52xxp1;
	struct cvmx_pcieep_cfg004_mask_s cn56xx;
	struct cvmx_pcieep_cfg004_mask_s cn56xxp1;
};

union cvmx_pcieep_cfg005 {
	uint32_t u32;
	struct cvmx_pcieep_cfg005_s {
		uint32_t ubab:32;
	} s;
	struct cvmx_pcieep_cfg005_s cn52xx;
	struct cvmx_pcieep_cfg005_s cn52xxp1;
	struct cvmx_pcieep_cfg005_s cn56xx;
	struct cvmx_pcieep_cfg005_s cn56xxp1;
};

union cvmx_pcieep_cfg005_mask {
	uint32_t u32;
	struct cvmx_pcieep_cfg005_mask_s {
		uint32_t umask:32;
	} s;
	struct cvmx_pcieep_cfg005_mask_s cn52xx;
	struct cvmx_pcieep_cfg005_mask_s cn52xxp1;
	struct cvmx_pcieep_cfg005_mask_s cn56xx;
	struct cvmx_pcieep_cfg005_mask_s cn56xxp1;
};

union cvmx_pcieep_cfg006 {
	uint32_t u32;
	struct cvmx_pcieep_cfg006_s {
		uint32_t lbab:6;
		uint32_t reserved_4_25:22;
		uint32_t pf:1;
		uint32_t typ:2;
		uint32_t mspc:1;
	} s;
	struct cvmx_pcieep_cfg006_s cn52xx;
	struct cvmx_pcieep_cfg006_s cn52xxp1;
	struct cvmx_pcieep_cfg006_s cn56xx;
	struct cvmx_pcieep_cfg006_s cn56xxp1;
};

union cvmx_pcieep_cfg006_mask {
	uint32_t u32;
	struct cvmx_pcieep_cfg006_mask_s {
		uint32_t lmask:31;
		uint32_t enb:1;
	} s;
	struct cvmx_pcieep_cfg006_mask_s cn52xx;
	struct cvmx_pcieep_cfg006_mask_s cn52xxp1;
	struct cvmx_pcieep_cfg006_mask_s cn56xx;
	struct cvmx_pcieep_cfg006_mask_s cn56xxp1;
};

union cvmx_pcieep_cfg007 {
	uint32_t u32;
	struct cvmx_pcieep_cfg007_s {
		uint32_t ubab:32;
	} s;
	struct cvmx_pcieep_cfg007_s cn52xx;
	struct cvmx_pcieep_cfg007_s cn52xxp1;
	struct cvmx_pcieep_cfg007_s cn56xx;
	struct cvmx_pcieep_cfg007_s cn56xxp1;
};

union cvmx_pcieep_cfg007_mask {
	uint32_t u32;
	struct cvmx_pcieep_cfg007_mask_s {
		uint32_t umask:32;
	} s;
	struct cvmx_pcieep_cfg007_mask_s cn52xx;
	struct cvmx_pcieep_cfg007_mask_s cn52xxp1;
	struct cvmx_pcieep_cfg007_mask_s cn56xx;
	struct cvmx_pcieep_cfg007_mask_s cn56xxp1;
};

union cvmx_pcieep_cfg008 {
	uint32_t u32;
	struct cvmx_pcieep_cfg008_s {
		uint32_t reserved_4_31:28;
		uint32_t pf:1;
		uint32_t typ:2;
		uint32_t mspc:1;
	} s;
	struct cvmx_pcieep_cfg008_s cn52xx;
	struct cvmx_pcieep_cfg008_s cn52xxp1;
	struct cvmx_pcieep_cfg008_s cn56xx;
	struct cvmx_pcieep_cfg008_s cn56xxp1;
};

union cvmx_pcieep_cfg008_mask {
	uint32_t u32;
	struct cvmx_pcieep_cfg008_mask_s {
		uint32_t lmask:31;
		uint32_t enb:1;
	} s;
	struct cvmx_pcieep_cfg008_mask_s cn52xx;
	struct cvmx_pcieep_cfg008_mask_s cn52xxp1;
	struct cvmx_pcieep_cfg008_mask_s cn56xx;
	struct cvmx_pcieep_cfg008_mask_s cn56xxp1;
};

union cvmx_pcieep_cfg009 {
	uint32_t u32;
	struct cvmx_pcieep_cfg009_s {
		uint32_t ubab:25;
		uint32_t reserved_0_6:7;
	} s;
	struct cvmx_pcieep_cfg009_s cn52xx;
	struct cvmx_pcieep_cfg009_s cn52xxp1;
	struct cvmx_pcieep_cfg009_s cn56xx;
	struct cvmx_pcieep_cfg009_s cn56xxp1;
};

union cvmx_pcieep_cfg009_mask {
	uint32_t u32;
	struct cvmx_pcieep_cfg009_mask_s {
		uint32_t umask:32;
	} s;
	struct cvmx_pcieep_cfg009_mask_s cn52xx;
	struct cvmx_pcieep_cfg009_mask_s cn52xxp1;
	struct cvmx_pcieep_cfg009_mask_s cn56xx;
	struct cvmx_pcieep_cfg009_mask_s cn56xxp1;
};

union cvmx_pcieep_cfg010 {
	uint32_t u32;
	struct cvmx_pcieep_cfg010_s {
		uint32_t cisp:32;
	} s;
	struct cvmx_pcieep_cfg010_s cn52xx;
	struct cvmx_pcieep_cfg010_s cn52xxp1;
	struct cvmx_pcieep_cfg010_s cn56xx;
	struct cvmx_pcieep_cfg010_s cn56xxp1;
};

union cvmx_pcieep_cfg011 {
	uint32_t u32;
	struct cvmx_pcieep_cfg011_s {
		uint32_t ssid:16;
		uint32_t ssvid:16;
	} s;
	struct cvmx_pcieep_cfg011_s cn52xx;
	struct cvmx_pcieep_cfg011_s cn52xxp1;
	struct cvmx_pcieep_cfg011_s cn56xx;
	struct cvmx_pcieep_cfg011_s cn56xxp1;
};

union cvmx_pcieep_cfg012 {
	uint32_t u32;
	struct cvmx_pcieep_cfg012_s {
		uint32_t eraddr:16;
		uint32_t reserved_1_15:15;
		uint32_t er_en:1;
	} s;
	struct cvmx_pcieep_cfg012_s cn52xx;
	struct cvmx_pcieep_cfg012_s cn52xxp1;
	struct cvmx_pcieep_cfg012_s cn56xx;
	struct cvmx_pcieep_cfg012_s cn56xxp1;
};

union cvmx_pcieep_cfg012_mask {
	uint32_t u32;
	struct cvmx_pcieep_cfg012_mask_s {
		uint32_t mask:31;
		uint32_t enb:1;
	} s;
	struct cvmx_pcieep_cfg012_mask_s cn52xx;
	struct cvmx_pcieep_cfg012_mask_s cn52xxp1;
	struct cvmx_pcieep_cfg012_mask_s cn56xx;
	struct cvmx_pcieep_cfg012_mask_s cn56xxp1;
};

union cvmx_pcieep_cfg013 {
	uint32_t u32;
	struct cvmx_pcieep_cfg013_s {
		uint32_t reserved_8_31:24;
		uint32_t cp:8;
	} s;
	struct cvmx_pcieep_cfg013_s cn52xx;
	struct cvmx_pcieep_cfg013_s cn52xxp1;
	struct cvmx_pcieep_cfg013_s cn56xx;
	struct cvmx_pcieep_cfg013_s cn56xxp1;
};

union cvmx_pcieep_cfg015 {
	uint32_t u32;
	struct cvmx_pcieep_cfg015_s {
		uint32_t ml:8;
		uint32_t mg:8;
		uint32_t inta:8;
		uint32_t il:8;
	} s;
	struct cvmx_pcieep_cfg015_s cn52xx;
	struct cvmx_pcieep_cfg015_s cn52xxp1;
	struct cvmx_pcieep_cfg015_s cn56xx;
	struct cvmx_pcieep_cfg015_s cn56xxp1;
};

union cvmx_pcieep_cfg016 {
	uint32_t u32;
	struct cvmx_pcieep_cfg016_s {
		uint32_t pmes:5;
		uint32_t d2s:1;
		uint32_t d1s:1;
		uint32_t auxc:3;
		uint32_t dsi:1;
		uint32_t reserved_20_20:1;
		uint32_t pme_clock:1;
		uint32_t pmsv:3;
		uint32_t ncp:8;
		uint32_t pmcid:8;
	} s;
	struct cvmx_pcieep_cfg016_s cn52xx;
	struct cvmx_pcieep_cfg016_s cn52xxp1;
	struct cvmx_pcieep_cfg016_s cn56xx;
	struct cvmx_pcieep_cfg016_s cn56xxp1;
};

union cvmx_pcieep_cfg017 {
	uint32_t u32;
	struct cvmx_pcieep_cfg017_s {
		uint32_t pmdia:8;
		uint32_t bpccee:1;
		uint32_t bd3h:1;
		uint32_t reserved_16_21:6;
		uint32_t pmess:1;
		uint32_t pmedsia:2;
		uint32_t pmds:4;
		uint32_t pmeens:1;
		uint32_t reserved_4_7:4;
		uint32_t nsr:1;
		uint32_t reserved_2_2:1;
		uint32_t ps:2;
	} s;
	struct cvmx_pcieep_cfg017_s cn52xx;
	struct cvmx_pcieep_cfg017_s cn52xxp1;
	struct cvmx_pcieep_cfg017_s cn56xx;
	struct cvmx_pcieep_cfg017_s cn56xxp1;
};

union cvmx_pcieep_cfg020 {
	uint32_t u32;
	struct cvmx_pcieep_cfg020_s {
		uint32_t reserved_24_31:8;
		uint32_t m64:1;
		uint32_t mme:3;
		uint32_t mmc:3;
		uint32_t msien:1;
		uint32_t ncp:8;
		uint32_t msicid:8;
	} s;
	struct cvmx_pcieep_cfg020_s cn52xx;
	struct cvmx_pcieep_cfg020_s cn52xxp1;
	struct cvmx_pcieep_cfg020_s cn56xx;
	struct cvmx_pcieep_cfg020_s cn56xxp1;
};

union cvmx_pcieep_cfg021 {
	uint32_t u32;
	struct cvmx_pcieep_cfg021_s {
		uint32_t lmsi:30;
		uint32_t reserved_0_1:2;
	} s;
	struct cvmx_pcieep_cfg021_s cn52xx;
	struct cvmx_pcieep_cfg021_s cn52xxp1;
	struct cvmx_pcieep_cfg021_s cn56xx;
	struct cvmx_pcieep_cfg021_s cn56xxp1;
};

union cvmx_pcieep_cfg022 {
	uint32_t u32;
	struct cvmx_pcieep_cfg022_s {
		uint32_t umsi:32;
	} s;
	struct cvmx_pcieep_cfg022_s cn52xx;
	struct cvmx_pcieep_cfg022_s cn52xxp1;
	struct cvmx_pcieep_cfg022_s cn56xx;
	struct cvmx_pcieep_cfg022_s cn56xxp1;
};

union cvmx_pcieep_cfg023 {
	uint32_t u32;
	struct cvmx_pcieep_cfg023_s {
		uint32_t reserved_16_31:16;
		uint32_t msimd:16;
	} s;
	struct cvmx_pcieep_cfg023_s cn52xx;
	struct cvmx_pcieep_cfg023_s cn52xxp1;
	struct cvmx_pcieep_cfg023_s cn56xx;
	struct cvmx_pcieep_cfg023_s cn56xxp1;
};

union cvmx_pcieep_cfg028 {
	uint32_t u32;
	struct cvmx_pcieep_cfg028_s {
		uint32_t reserved_30_31:2;
		uint32_t imn:5;
		uint32_t si:1;
		uint32_t dpt:4;
		uint32_t pciecv:4;
		uint32_t ncp:8;
		uint32_t pcieid:8;
	} s;
	struct cvmx_pcieep_cfg028_s cn52xx;
	struct cvmx_pcieep_cfg028_s cn52xxp1;
	struct cvmx_pcieep_cfg028_s cn56xx;
	struct cvmx_pcieep_cfg028_s cn56xxp1;
};

union cvmx_pcieep_cfg029 {
	uint32_t u32;
	struct cvmx_pcieep_cfg029_s {
		uint32_t reserved_28_31:4;
		uint32_t cspls:2;
		uint32_t csplv:8;
		uint32_t reserved_16_17:2;
		uint32_t rber:1;
		uint32_t reserved_12_14:3;
		uint32_t el1al:3;
		uint32_t el0al:3;
		uint32_t etfs:1;
		uint32_t pfs:2;
		uint32_t mpss:3;
	} s;
	struct cvmx_pcieep_cfg029_s cn52xx;
	struct cvmx_pcieep_cfg029_s cn52xxp1;
	struct cvmx_pcieep_cfg029_s cn56xx;
	struct cvmx_pcieep_cfg029_s cn56xxp1;
};

union cvmx_pcieep_cfg030 {
	uint32_t u32;
	struct cvmx_pcieep_cfg030_s {
		uint32_t reserved_22_31:10;
		uint32_t tp:1;
		uint32_t ap_d:1;
		uint32_t ur_d:1;
		uint32_t fe_d:1;
		uint32_t nfe_d:1;
		uint32_t ce_d:1;
		uint32_t reserved_15_15:1;
		uint32_t mrrs:3;
		uint32_t ns_en:1;
		uint32_t ap_en:1;
		uint32_t pf_en:1;
		uint32_t etf_en:1;
		uint32_t mps:3;
		uint32_t ro_en:1;
		uint32_t ur_en:1;
		uint32_t fe_en:1;
		uint32_t nfe_en:1;
		uint32_t ce_en:1;
	} s;
	struct cvmx_pcieep_cfg030_s cn52xx;
	struct cvmx_pcieep_cfg030_s cn52xxp1;
	struct cvmx_pcieep_cfg030_s cn56xx;
	struct cvmx_pcieep_cfg030_s cn56xxp1;
};

union cvmx_pcieep_cfg031 {
	uint32_t u32;
	struct cvmx_pcieep_cfg031_s {
		uint32_t pnum:8;
		uint32_t reserved_22_23:2;
		uint32_t lbnc:1;
		uint32_t dllarc:1;
		uint32_t sderc:1;
		uint32_t cpm:1;
		uint32_t l1el:3;
		uint32_t l0el:3;
		uint32_t aslpms:2;
		uint32_t mlw:6;
		uint32_t mls:4;
	} s;
	struct cvmx_pcieep_cfg031_s cn52xx;
	struct cvmx_pcieep_cfg031_s cn52xxp1;
	struct cvmx_pcieep_cfg031_s cn56xx;
	struct cvmx_pcieep_cfg031_s cn56xxp1;
};

union cvmx_pcieep_cfg032 {
	uint32_t u32;
	struct cvmx_pcieep_cfg032_s {
		uint32_t reserved_30_31:2;
		uint32_t dlla:1;
		uint32_t scc:1;
		uint32_t lt:1;
		uint32_t reserved_26_26:1;
		uint32_t nlw:6;
		uint32_t ls:4;
		uint32_t reserved_10_15:6;
		uint32_t hawd:1;
		uint32_t ecpm:1;
		uint32_t es:1;
		uint32_t ccc:1;
		uint32_t rl:1;
		uint32_t ld:1;
		uint32_t rcb:1;
		uint32_t reserved_2_2:1;
		uint32_t aslpc:2;
	} s;
	struct cvmx_pcieep_cfg032_s cn52xx;
	struct cvmx_pcieep_cfg032_s cn52xxp1;
	struct cvmx_pcieep_cfg032_s cn56xx;
	struct cvmx_pcieep_cfg032_s cn56xxp1;
};

union cvmx_pcieep_cfg033 {
	uint32_t u32;
	struct cvmx_pcieep_cfg033_s {
		uint32_t ps_num:13;
		uint32_t nccs:1;
		uint32_t emip:1;
		uint32_t sp_ls:2;
		uint32_t sp_lv:8;
		uint32_t hp_c:1;
		uint32_t hp_s:1;
		uint32_t pip:1;
		uint32_t aip:1;
		uint32_t mrlsp:1;
		uint32_t pcp:1;
		uint32_t abp:1;
	} s;
	struct cvmx_pcieep_cfg033_s cn52xx;
	struct cvmx_pcieep_cfg033_s cn52xxp1;
	struct cvmx_pcieep_cfg033_s cn56xx;
	struct cvmx_pcieep_cfg033_s cn56xxp1;
};

union cvmx_pcieep_cfg034 {
	uint32_t u32;
	struct cvmx_pcieep_cfg034_s {
		uint32_t reserved_25_31:7;
		uint32_t dlls_c:1;
		uint32_t emis:1;
		uint32_t pds:1;
		uint32_t mrlss:1;
		uint32_t ccint_d:1;
		uint32_t pd_c:1;
		uint32_t mrls_c:1;
		uint32_t pf_d:1;
		uint32_t abp_d:1;
		uint32_t reserved_13_15:3;
		uint32_t dlls_en:1;
		uint32_t emic:1;
		uint32_t pcc:1;
		uint32_t pic:2;
		uint32_t aic:2;
		uint32_t hpint_en:1;
		uint32_t ccint_en:1;
		uint32_t pd_en:1;
		uint32_t mrls_en:1;
		uint32_t pf_en:1;
		uint32_t abp_en:1;
	} s;
	struct cvmx_pcieep_cfg034_s cn52xx;
	struct cvmx_pcieep_cfg034_s cn52xxp1;
	struct cvmx_pcieep_cfg034_s cn56xx;
	struct cvmx_pcieep_cfg034_s cn56xxp1;
};

union cvmx_pcieep_cfg037 {
	uint32_t u32;
	struct cvmx_pcieep_cfg037_s {
		uint32_t reserved_5_31:27;
		uint32_t ctds:1;
		uint32_t ctrs:4;
	} s;
	struct cvmx_pcieep_cfg037_s cn52xx;
	struct cvmx_pcieep_cfg037_s cn52xxp1;
	struct cvmx_pcieep_cfg037_s cn56xx;
	struct cvmx_pcieep_cfg037_s cn56xxp1;
};

union cvmx_pcieep_cfg038 {
	uint32_t u32;
	struct cvmx_pcieep_cfg038_s {
		uint32_t reserved_5_31:27;
		uint32_t ctd:1;
		uint32_t ctv:4;
	} s;
	struct cvmx_pcieep_cfg038_s cn52xx;
	struct cvmx_pcieep_cfg038_s cn52xxp1;
	struct cvmx_pcieep_cfg038_s cn56xx;
	struct cvmx_pcieep_cfg038_s cn56xxp1;
};

union cvmx_pcieep_cfg039 {
	uint32_t u32;
	struct cvmx_pcieep_cfg039_s {
		uint32_t reserved_0_31:32;
	} s;
	struct cvmx_pcieep_cfg039_s cn52xx;
	struct cvmx_pcieep_cfg039_s cn52xxp1;
	struct cvmx_pcieep_cfg039_s cn56xx;
	struct cvmx_pcieep_cfg039_s cn56xxp1;
};

union cvmx_pcieep_cfg040 {
	uint32_t u32;
	struct cvmx_pcieep_cfg040_s {
		uint32_t reserved_0_31:32;
	} s;
	struct cvmx_pcieep_cfg040_s cn52xx;
	struct cvmx_pcieep_cfg040_s cn52xxp1;
	struct cvmx_pcieep_cfg040_s cn56xx;
	struct cvmx_pcieep_cfg040_s cn56xxp1;
};

union cvmx_pcieep_cfg041 {
	uint32_t u32;
	struct cvmx_pcieep_cfg041_s {
		uint32_t reserved_0_31:32;
	} s;
	struct cvmx_pcieep_cfg041_s cn52xx;
	struct cvmx_pcieep_cfg041_s cn52xxp1;
	struct cvmx_pcieep_cfg041_s cn56xx;
	struct cvmx_pcieep_cfg041_s cn56xxp1;
};

union cvmx_pcieep_cfg042 {
	uint32_t u32;
	struct cvmx_pcieep_cfg042_s {
		uint32_t reserved_0_31:32;
	} s;
	struct cvmx_pcieep_cfg042_s cn52xx;
	struct cvmx_pcieep_cfg042_s cn52xxp1;
	struct cvmx_pcieep_cfg042_s cn56xx;
	struct cvmx_pcieep_cfg042_s cn56xxp1;
};

union cvmx_pcieep_cfg064 {
	uint32_t u32;
	struct cvmx_pcieep_cfg064_s {
		uint32_t nco:12;
		uint32_t cv:4;
		uint32_t pcieec:16;
	} s;
	struct cvmx_pcieep_cfg064_s cn52xx;
	struct cvmx_pcieep_cfg064_s cn52xxp1;
	struct cvmx_pcieep_cfg064_s cn56xx;
	struct cvmx_pcieep_cfg064_s cn56xxp1;
};

union cvmx_pcieep_cfg065 {
	uint32_t u32;
	struct cvmx_pcieep_cfg065_s {
		uint32_t reserved_21_31:11;
		uint32_t ures:1;
		uint32_t ecrces:1;
		uint32_t mtlps:1;
		uint32_t ros:1;
		uint32_t ucs:1;
		uint32_t cas:1;
		uint32_t cts:1;
		uint32_t fcpes:1;
		uint32_t ptlps:1;
		uint32_t reserved_6_11:6;
		uint32_t sdes:1;
		uint32_t dlpes:1;
		uint32_t reserved_0_3:4;
	} s;
	struct cvmx_pcieep_cfg065_s cn52xx;
	struct cvmx_pcieep_cfg065_s cn52xxp1;
	struct cvmx_pcieep_cfg065_s cn56xx;
	struct cvmx_pcieep_cfg065_s cn56xxp1;
};

union cvmx_pcieep_cfg066 {
	uint32_t u32;
	struct cvmx_pcieep_cfg066_s {
		uint32_t reserved_21_31:11;
		uint32_t urem:1;
		uint32_t ecrcem:1;
		uint32_t mtlpm:1;
		uint32_t rom:1;
		uint32_t ucm:1;
		uint32_t cam:1;
		uint32_t ctm:1;
		uint32_t fcpem:1;
		uint32_t ptlpm:1;
		uint32_t reserved_6_11:6;
		uint32_t sdem:1;
		uint32_t dlpem:1;
		uint32_t reserved_0_3:4;
	} s;
	struct cvmx_pcieep_cfg066_s cn52xx;
	struct cvmx_pcieep_cfg066_s cn52xxp1;
	struct cvmx_pcieep_cfg066_s cn56xx;
	struct cvmx_pcieep_cfg066_s cn56xxp1;
};

union cvmx_pcieep_cfg067 {
	uint32_t u32;
	struct cvmx_pcieep_cfg067_s {
		uint32_t reserved_21_31:11;
		uint32_t ures:1;
		uint32_t ecrces:1;
		uint32_t mtlps:1;
		uint32_t ros:1;
		uint32_t ucs:1;
		uint32_t cas:1;
		uint32_t cts:1;
		uint32_t fcpes:1;
		uint32_t ptlps:1;
		uint32_t reserved_6_11:6;
		uint32_t sdes:1;
		uint32_t dlpes:1;
		uint32_t reserved_0_3:4;
	} s;
	struct cvmx_pcieep_cfg067_s cn52xx;
	struct cvmx_pcieep_cfg067_s cn52xxp1;
	struct cvmx_pcieep_cfg067_s cn56xx;
	struct cvmx_pcieep_cfg067_s cn56xxp1;
};

union cvmx_pcieep_cfg068 {
	uint32_t u32;
	struct cvmx_pcieep_cfg068_s {
		uint32_t reserved_14_31:18;
		uint32_t anfes:1;
		uint32_t rtts:1;
		uint32_t reserved_9_11:3;
		uint32_t rnrs:1;
		uint32_t bdllps:1;
		uint32_t btlps:1;
		uint32_t reserved_1_5:5;
		uint32_t res:1;
	} s;
	struct cvmx_pcieep_cfg068_s cn52xx;
	struct cvmx_pcieep_cfg068_s cn52xxp1;
	struct cvmx_pcieep_cfg068_s cn56xx;
	struct cvmx_pcieep_cfg068_s cn56xxp1;
};

union cvmx_pcieep_cfg069 {
	uint32_t u32;
	struct cvmx_pcieep_cfg069_s {
		uint32_t reserved_14_31:18;
		uint32_t anfem:1;
		uint32_t rttm:1;
		uint32_t reserved_9_11:3;
		uint32_t rnrm:1;
		uint32_t bdllpm:1;
		uint32_t btlpm:1;
		uint32_t reserved_1_5:5;
		uint32_t rem:1;
	} s;
	struct cvmx_pcieep_cfg069_s cn52xx;
	struct cvmx_pcieep_cfg069_s cn52xxp1;
	struct cvmx_pcieep_cfg069_s cn56xx;
	struct cvmx_pcieep_cfg069_s cn56xxp1;
};

union cvmx_pcieep_cfg070 {
	uint32_t u32;
	struct cvmx_pcieep_cfg070_s {
		uint32_t reserved_9_31:23;
		uint32_t ce:1;
		uint32_t cc:1;
		uint32_t ge:1;
		uint32_t gc:1;
		uint32_t fep:5;
	} s;
	struct cvmx_pcieep_cfg070_s cn52xx;
	struct cvmx_pcieep_cfg070_s cn52xxp1;
	struct cvmx_pcieep_cfg070_s cn56xx;
	struct cvmx_pcieep_cfg070_s cn56xxp1;
};

union cvmx_pcieep_cfg071 {
	uint32_t u32;
	struct cvmx_pcieep_cfg071_s {
		uint32_t dword1:32;
	} s;
	struct cvmx_pcieep_cfg071_s cn52xx;
	struct cvmx_pcieep_cfg071_s cn52xxp1;
	struct cvmx_pcieep_cfg071_s cn56xx;
	struct cvmx_pcieep_cfg071_s cn56xxp1;
};

union cvmx_pcieep_cfg072 {
	uint32_t u32;
	struct cvmx_pcieep_cfg072_s {
		uint32_t dword2:32;
	} s;
	struct cvmx_pcieep_cfg072_s cn52xx;
	struct cvmx_pcieep_cfg072_s cn52xxp1;
	struct cvmx_pcieep_cfg072_s cn56xx;
	struct cvmx_pcieep_cfg072_s cn56xxp1;
};

union cvmx_pcieep_cfg073 {
	uint32_t u32;
	struct cvmx_pcieep_cfg073_s {
		uint32_t dword3:32;
	} s;
	struct cvmx_pcieep_cfg073_s cn52xx;
	struct cvmx_pcieep_cfg073_s cn52xxp1;
	struct cvmx_pcieep_cfg073_s cn56xx;
	struct cvmx_pcieep_cfg073_s cn56xxp1;
};

union cvmx_pcieep_cfg074 {
	uint32_t u32;
	struct cvmx_pcieep_cfg074_s {
		uint32_t dword4:32;
	} s;
	struct cvmx_pcieep_cfg074_s cn52xx;
	struct cvmx_pcieep_cfg074_s cn52xxp1;
	struct cvmx_pcieep_cfg074_s cn56xx;
	struct cvmx_pcieep_cfg074_s cn56xxp1;
};

union cvmx_pcieep_cfg448 {
	uint32_t u32;
	struct cvmx_pcieep_cfg448_s {
		uint32_t rtl:16;
		uint32_t rtltl:16;
	} s;
	struct cvmx_pcieep_cfg448_s cn52xx;
	struct cvmx_pcieep_cfg448_s cn52xxp1;
	struct cvmx_pcieep_cfg448_s cn56xx;
	struct cvmx_pcieep_cfg448_s cn56xxp1;
};

union cvmx_pcieep_cfg449 {
	uint32_t u32;
	struct cvmx_pcieep_cfg449_s {
		uint32_t omr:32;
	} s;
	struct cvmx_pcieep_cfg449_s cn52xx;
	struct cvmx_pcieep_cfg449_s cn52xxp1;
	struct cvmx_pcieep_cfg449_s cn56xx;
	struct cvmx_pcieep_cfg449_s cn56xxp1;
};

union cvmx_pcieep_cfg450 {
	uint32_t u32;
	struct cvmx_pcieep_cfg450_s {
		uint32_t lpec:8;
		uint32_t reserved_22_23:2;
		uint32_t link_state:6;
		uint32_t force_link:1;
		uint32_t reserved_8_14:7;
		uint32_t link_num:8;
	} s;
	struct cvmx_pcieep_cfg450_s cn52xx;
	struct cvmx_pcieep_cfg450_s cn52xxp1;
	struct cvmx_pcieep_cfg450_s cn56xx;
	struct cvmx_pcieep_cfg450_s cn56xxp1;
};

union cvmx_pcieep_cfg451 {
	uint32_t u32;
	struct cvmx_pcieep_cfg451_s {
		uint32_t reserved_30_31:2;
		uint32_t l1el:3;
		uint32_t l0el:3;
		uint32_t n_fts_cc:8;
		uint32_t n_fts:8;
		uint32_t ack_freq:8;
	} s;
	struct cvmx_pcieep_cfg451_s cn52xx;
	struct cvmx_pcieep_cfg451_s cn52xxp1;
	struct cvmx_pcieep_cfg451_s cn56xx;
	struct cvmx_pcieep_cfg451_s cn56xxp1;
};

union cvmx_pcieep_cfg452 {
	uint32_t u32;
	struct cvmx_pcieep_cfg452_s {
		uint32_t reserved_26_31:6;
		uint32_t eccrc:1;
		uint32_t reserved_22_24:3;
		uint32_t lme:6;
		uint32_t reserved_8_15:8;
		uint32_t flm:1;
		uint32_t reserved_6_6:1;
		uint32_t dllle:1;
		uint32_t reserved_4_4:1;
		uint32_t ra:1;
		uint32_t le:1;
		uint32_t sd:1;
		uint32_t omr:1;
	} s;
	struct cvmx_pcieep_cfg452_s cn52xx;
	struct cvmx_pcieep_cfg452_s cn52xxp1;
	struct cvmx_pcieep_cfg452_s cn56xx;
	struct cvmx_pcieep_cfg452_s cn56xxp1;
};

union cvmx_pcieep_cfg453 {
	uint32_t u32;
	struct cvmx_pcieep_cfg453_s {
		uint32_t dlld:1;
		uint32_t reserved_26_30:5;
		uint32_t ack_nak:1;
		uint32_t fcd:1;
		uint32_t ilst:24;
	} s;
	struct cvmx_pcieep_cfg453_s cn52xx;
	struct cvmx_pcieep_cfg453_s cn52xxp1;
	struct cvmx_pcieep_cfg453_s cn56xx;
	struct cvmx_pcieep_cfg453_s cn56xxp1;
};

union cvmx_pcieep_cfg454 {
	uint32_t u32;
	struct cvmx_pcieep_cfg454_s {
		uint32_t reserved_29_31:3;
		uint32_t tmfcwt:5;
		uint32_t tmanlt:5;
		uint32_t tmrt:5;
		uint32_t reserved_11_13:3;
		uint32_t nskps:3;
		uint32_t reserved_4_7:4;
		uint32_t ntss:4;
	} s;
	struct cvmx_pcieep_cfg454_s cn52xx;
	struct cvmx_pcieep_cfg454_s cn52xxp1;
	struct cvmx_pcieep_cfg454_s cn56xx;
	struct cvmx_pcieep_cfg454_s cn56xxp1;
};

union cvmx_pcieep_cfg455 {
	uint32_t u32;
	struct cvmx_pcieep_cfg455_s {
		uint32_t m_cfg0_filt:1;
		uint32_t m_io_filt:1;
		uint32_t msg_ctrl:1;
		uint32_t m_cpl_ecrc_filt:1;
		uint32_t m_ecrc_filt:1;
		uint32_t m_cpl_len_err:1;
		uint32_t m_cpl_attr_err:1;
		uint32_t m_cpl_tc_err:1;
		uint32_t m_cpl_fun_err:1;
		uint32_t m_cpl_rid_err:1;
		uint32_t m_cpl_tag_err:1;
		uint32_t m_lk_filt:1;
		uint32_t m_cfg1_filt:1;
		uint32_t m_bar_match:1;
		uint32_t m_pois_filt:1;
		uint32_t m_fun:1;
		uint32_t dfcwt:1;
		uint32_t reserved_11_14:4;
		uint32_t skpiv:11;
	} s;
	struct cvmx_pcieep_cfg455_s cn52xx;
	struct cvmx_pcieep_cfg455_s cn52xxp1;
	struct cvmx_pcieep_cfg455_s cn56xx;
	struct cvmx_pcieep_cfg455_s cn56xxp1;
};

union cvmx_pcieep_cfg456 {
	uint32_t u32;
	struct cvmx_pcieep_cfg456_s {
		uint32_t reserved_2_31:30;
		uint32_t m_vend1_drp:1;
		uint32_t m_vend0_drp:1;
	} s;
	struct cvmx_pcieep_cfg456_s cn52xx;
	struct cvmx_pcieep_cfg456_s cn52xxp1;
	struct cvmx_pcieep_cfg456_s cn56xx;
	struct cvmx_pcieep_cfg456_s cn56xxp1;
};

union cvmx_pcieep_cfg458 {
	uint32_t u32;
	struct cvmx_pcieep_cfg458_s {
		uint32_t dbg_info_l32:32;
	} s;
	struct cvmx_pcieep_cfg458_s cn52xx;
	struct cvmx_pcieep_cfg458_s cn52xxp1;
	struct cvmx_pcieep_cfg458_s cn56xx;
	struct cvmx_pcieep_cfg458_s cn56xxp1;
};

union cvmx_pcieep_cfg459 {
	uint32_t u32;
	struct cvmx_pcieep_cfg459_s {
		uint32_t dbg_info_u32:32;
	} s;
	struct cvmx_pcieep_cfg459_s cn52xx;
	struct cvmx_pcieep_cfg459_s cn52xxp1;
	struct cvmx_pcieep_cfg459_s cn56xx;
	struct cvmx_pcieep_cfg459_s cn56xxp1;
};

union cvmx_pcieep_cfg460 {
	uint32_t u32;
	struct cvmx_pcieep_cfg460_s {
		uint32_t reserved_20_31:12;
		uint32_t tphfcc:8;
		uint32_t tpdfcc:12;
	} s;
	struct cvmx_pcieep_cfg460_s cn52xx;
	struct cvmx_pcieep_cfg460_s cn52xxp1;
	struct cvmx_pcieep_cfg460_s cn56xx;
	struct cvmx_pcieep_cfg460_s cn56xxp1;
};

union cvmx_pcieep_cfg461 {
	uint32_t u32;
	struct cvmx_pcieep_cfg461_s {
		uint32_t reserved_20_31:12;
		uint32_t tchfcc:8;
		uint32_t tcdfcc:12;
	} s;
	struct cvmx_pcieep_cfg461_s cn52xx;
	struct cvmx_pcieep_cfg461_s cn52xxp1;
	struct cvmx_pcieep_cfg461_s cn56xx;
	struct cvmx_pcieep_cfg461_s cn56xxp1;
};

union cvmx_pcieep_cfg462 {
	uint32_t u32;
	struct cvmx_pcieep_cfg462_s {
		uint32_t reserved_20_31:12;
		uint32_t tchfcc:8;
		uint32_t tcdfcc:12;
	} s;
	struct cvmx_pcieep_cfg462_s cn52xx;
	struct cvmx_pcieep_cfg462_s cn52xxp1;
	struct cvmx_pcieep_cfg462_s cn56xx;
	struct cvmx_pcieep_cfg462_s cn56xxp1;
};

union cvmx_pcieep_cfg463 {
	uint32_t u32;
	struct cvmx_pcieep_cfg463_s {
		uint32_t reserved_3_31:29;
		uint32_t rqne:1;
		uint32_t trbne:1;
		uint32_t rtlpfccnr:1;
	} s;
	struct cvmx_pcieep_cfg463_s cn52xx;
	struct cvmx_pcieep_cfg463_s cn52xxp1;
	struct cvmx_pcieep_cfg463_s cn56xx;
	struct cvmx_pcieep_cfg463_s cn56xxp1;
};

union cvmx_pcieep_cfg464 {
	uint32_t u32;
	struct cvmx_pcieep_cfg464_s {
		uint32_t wrr_vc3:8;
		uint32_t wrr_vc2:8;
		uint32_t wrr_vc1:8;
		uint32_t wrr_vc0:8;
	} s;
	struct cvmx_pcieep_cfg464_s cn52xx;
	struct cvmx_pcieep_cfg464_s cn52xxp1;
	struct cvmx_pcieep_cfg464_s cn56xx;
	struct cvmx_pcieep_cfg464_s cn56xxp1;
};

union cvmx_pcieep_cfg465 {
	uint32_t u32;
	struct cvmx_pcieep_cfg465_s {
		uint32_t wrr_vc7:8;
		uint32_t wrr_vc6:8;
		uint32_t wrr_vc5:8;
		uint32_t wrr_vc4:8;
	} s;
	struct cvmx_pcieep_cfg465_s cn52xx;
	struct cvmx_pcieep_cfg465_s cn52xxp1;
	struct cvmx_pcieep_cfg465_s cn56xx;
	struct cvmx_pcieep_cfg465_s cn56xxp1;
};

union cvmx_pcieep_cfg466 {
	uint32_t u32;
	struct cvmx_pcieep_cfg466_s {
		uint32_t rx_queue_order:1;
		uint32_t type_ordering:1;
		uint32_t reserved_24_29:6;
		uint32_t queue_mode:3;
		uint32_t reserved_20_20:1;
		uint32_t header_credits:8;
		uint32_t data_credits:12;
	} s;
	struct cvmx_pcieep_cfg466_s cn52xx;
	struct cvmx_pcieep_cfg466_s cn52xxp1;
	struct cvmx_pcieep_cfg466_s cn56xx;
	struct cvmx_pcieep_cfg466_s cn56xxp1;
};

union cvmx_pcieep_cfg467 {
	uint32_t u32;
	struct cvmx_pcieep_cfg467_s {
		uint32_t reserved_24_31:8;
		uint32_t queue_mode:3;
		uint32_t reserved_20_20:1;
		uint32_t header_credits:8;
		uint32_t data_credits:12;
	} s;
	struct cvmx_pcieep_cfg467_s cn52xx;
	struct cvmx_pcieep_cfg467_s cn52xxp1;
	struct cvmx_pcieep_cfg467_s cn56xx;
	struct cvmx_pcieep_cfg467_s cn56xxp1;
};

union cvmx_pcieep_cfg468 {
	uint32_t u32;
	struct cvmx_pcieep_cfg468_s {
		uint32_t reserved_24_31:8;
		uint32_t queue_mode:3;
		uint32_t reserved_20_20:1;
		uint32_t header_credits:8;
		uint32_t data_credits:12;
	} s;
	struct cvmx_pcieep_cfg468_s cn52xx;
	struct cvmx_pcieep_cfg468_s cn52xxp1;
	struct cvmx_pcieep_cfg468_s cn56xx;
	struct cvmx_pcieep_cfg468_s cn56xxp1;
};

union cvmx_pcieep_cfg490 {
	uint32_t u32;
	struct cvmx_pcieep_cfg490_s {
		uint32_t reserved_26_31:6;
		uint32_t header_depth:10;
		uint32_t reserved_14_15:2;
		uint32_t data_depth:14;
	} s;
	struct cvmx_pcieep_cfg490_s cn52xx;
	struct cvmx_pcieep_cfg490_s cn52xxp1;
	struct cvmx_pcieep_cfg490_s cn56xx;
	struct cvmx_pcieep_cfg490_s cn56xxp1;
};

union cvmx_pcieep_cfg491 {
	uint32_t u32;
	struct cvmx_pcieep_cfg491_s {
		uint32_t reserved_26_31:6;
		uint32_t header_depth:10;
		uint32_t reserved_14_15:2;
		uint32_t data_depth:14;
	} s;
	struct cvmx_pcieep_cfg491_s cn52xx;
	struct cvmx_pcieep_cfg491_s cn52xxp1;
	struct cvmx_pcieep_cfg491_s cn56xx;
	struct cvmx_pcieep_cfg491_s cn56xxp1;
};

union cvmx_pcieep_cfg492 {
	uint32_t u32;
	struct cvmx_pcieep_cfg492_s {
		uint32_t reserved_26_31:6;
		uint32_t header_depth:10;
		uint32_t reserved_14_15:2;
		uint32_t data_depth:14;
	} s;
	struct cvmx_pcieep_cfg492_s cn52xx;
	struct cvmx_pcieep_cfg492_s cn52xxp1;
	struct cvmx_pcieep_cfg492_s cn56xx;
	struct cvmx_pcieep_cfg492_s cn56xxp1;
};

union cvmx_pcieep_cfg516 {
	uint32_t u32;
	struct cvmx_pcieep_cfg516_s {
		uint32_t phy_stat:32;
	} s;
	struct cvmx_pcieep_cfg516_s cn52xx;
	struct cvmx_pcieep_cfg516_s cn52xxp1;
	struct cvmx_pcieep_cfg516_s cn56xx;
	struct cvmx_pcieep_cfg516_s cn56xxp1;
};

union cvmx_pcieep_cfg517 {
	uint32_t u32;
	struct cvmx_pcieep_cfg517_s {
		uint32_t phy_ctrl:32;
	} s;
	struct cvmx_pcieep_cfg517_s cn52xx;
	struct cvmx_pcieep_cfg517_s cn52xxp1;
	struct cvmx_pcieep_cfg517_s cn56xx;
	struct cvmx_pcieep_cfg517_s cn56xxp1;
};

#endif
