# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import PeeringManagementClientConfiguration
from .operations import CdnPeeringPrefixesOperations
from .operations import PeeringManagementClientOperationsMixin
from .operations import LegacyPeeringsOperations
from .operations import Operations
from .operations import PeerAsnsOperations
from .operations import PeeringLocationsOperations
from .operations import RegisteredAsnsOperations
from .operations import RegisteredPrefixesOperations
from .operations import PeeringsOperations
from .operations import ReceivedRoutesOperations
from .operations import PeeringServiceCountriesOperations
from .operations import PeeringServiceLocationsOperations
from .operations import PrefixesOperations
from .operations import PeeringServiceProvidersOperations
from .operations import PeeringServicesOperations
from . import models


class PeeringManagementClient(PeeringManagementClientOperationsMixin):
    """Peering Client.

    :ivar cdn_peering_prefixes: CdnPeeringPrefixesOperations operations
    :vartype cdn_peering_prefixes: azure.mgmt.peering.operations.CdnPeeringPrefixesOperations
    :ivar legacy_peerings: LegacyPeeringsOperations operations
    :vartype legacy_peerings: azure.mgmt.peering.operations.LegacyPeeringsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.peering.operations.Operations
    :ivar peer_asns: PeerAsnsOperations operations
    :vartype peer_asns: azure.mgmt.peering.operations.PeerAsnsOperations
    :ivar peering_locations: PeeringLocationsOperations operations
    :vartype peering_locations: azure.mgmt.peering.operations.PeeringLocationsOperations
    :ivar registered_asns: RegisteredAsnsOperations operations
    :vartype registered_asns: azure.mgmt.peering.operations.RegisteredAsnsOperations
    :ivar registered_prefixes: RegisteredPrefixesOperations operations
    :vartype registered_prefixes: azure.mgmt.peering.operations.RegisteredPrefixesOperations
    :ivar peerings: PeeringsOperations operations
    :vartype peerings: azure.mgmt.peering.operations.PeeringsOperations
    :ivar received_routes: ReceivedRoutesOperations operations
    :vartype received_routes: azure.mgmt.peering.operations.ReceivedRoutesOperations
    :ivar peering_service_countries: PeeringServiceCountriesOperations operations
    :vartype peering_service_countries: azure.mgmt.peering.operations.PeeringServiceCountriesOperations
    :ivar peering_service_locations: PeeringServiceLocationsOperations operations
    :vartype peering_service_locations: azure.mgmt.peering.operations.PeeringServiceLocationsOperations
    :ivar prefixes: PrefixesOperations operations
    :vartype prefixes: azure.mgmt.peering.operations.PrefixesOperations
    :ivar peering_service_providers: PeeringServiceProvidersOperations operations
    :vartype peering_service_providers: azure.mgmt.peering.operations.PeeringServiceProvidersOperations
    :ivar peering_services: PeeringServicesOperations operations
    :vartype peering_services: azure.mgmt.peering.operations.PeeringServicesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = PeeringManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.cdn_peering_prefixes = CdnPeeringPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.legacy_peerings = LegacyPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peer_asns = PeerAsnsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_locations = PeeringLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.registered_asns = RegisteredAsnsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.registered_prefixes = RegisteredPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peerings = PeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.received_routes = ReceivedRoutesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_countries = PeeringServiceCountriesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_locations = PeeringServiceLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.prefixes = PrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_providers = PeeringServiceProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_services = PeeringServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> PeeringManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
