/*************************************************************
 *                                                           *
 *    ths  Filesystem                  04.08.94      V0.1    *
 *                                                           *
 *    Thomas Scheuermann     ths@ai-lab.fh-furtwangen.de     *
 *                                                           *
 *************************************************************/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/stat.h>
#include <linux/mm.h>
#include <linux/locks.h>
#include <linux/fs.h>
#include <linux/malloc.h>

#include <asm/system.h>
#include <asm/segment.h>
#include <asm/bitops.h>

#include "ths.h"
#include "ths_i.h"

#define UNIX_4_JAHRE 126230400
#define UNIX_JAHR 31536000
#define UNIX_TAG 86400
#define UNIX_STUNDE 3600
#define UNIX_MINUTE 60

/*
 * Umrechnung des MSDOS-Zeiteintrags in Unix-Format.
 */

long time_ms2u(unsigned short datum, unsigned short zeit)
{
	unsigned long jahr,monat,tag,stunde,minute,sekunde;
	unsigned long unix_zeit;
	unsigned long tab[] = {31,28,31,30,31,30,31,31,30,31,30,31};
	int i;

	jahr = (long)(datum >> 9);
	monat = (long)(datum & 0x01e0) >> 5;
	tag = (long)(datum & 0x001f);
	stunde = (long)(zeit >> 11);
	minute = (long)(zeit & 0x07e0) >> 5;
	sekunde = (long)(zeit & 0x001f)*2;

	unix_zeit=0;
	jahr += 1980;
	unix_zeit += ((jahr - 1970 + 1)>>2) * UNIX_4_JAHRE - UNIX_JAHR;
	unix_zeit += ((jahr - 1970 + 1) & 0x03) * UNIX_JAHR;
	for(i=1;i<monat;i++)
	{
		unix_zeit += tab[i-1] * UNIX_TAG;
		if(i==2 && ((jahr - 1970 + 1) & 0x03)==3)
			unix_zeit += UNIX_TAG;
	}
	unix_zeit += (tag-1) * UNIX_TAG;
	unix_zeit += stunde * UNIX_STUNDE;
	unix_zeit += minute * UNIX_MINUTE;
	unix_zeit += sekunde;
	return unix_zeit;
}


/*
 * Vergleich des Namens im Verzeichniseintrag mit
 * dem uebergebenen Namen.
 */

int vergleich(struct ths_dir *dir, const char *name, int l)
{
	int j,k,test;

/*
 * Namensvergleich
 */
	test=1;
	for(k=0,j=0;k<11;k++)
	{
/*
 * .-Abfrage
 */
		if(k==8 && dir->name[k]!=0x20)
		{
			if(name[j]!='.')
			{
				test = 0;
				break;
			}
			j++;
		}
		if(dir->name[k]!=0x20||(j<l))
		{
			if(((unsigned char)name[j]!=dir->name[k])&&(name[j]!='.'))
			{
				test = 0;
				break;
			}
			if(dir->name[k]!=0x20)
				j++;
		}
	}
/*
 * Test auf Volume-Namen
 */
	if(dir->attribut & 0x08)
		test=0;

	return test;
}

