/*
 * ps.h
 *
 * Copyright (c) 1992 Branko Lankester
 *
 */


#include <linux/sched.h>

extern int show_env;	/* -e flag */
extern int kern_comm;	/* -c flag */
extern int maxcmd;

extern char *swappath[];
extern char *kmem_path;

#define	MAXCMD	512	/* max # bytes to copy from args/env */

#define	PZERO	15	/* priority of init (in sched.h) */

#define	PAGE_MASK	0xfff

#define       KSTK_EIP(stack) ((stack)[1019])
#define       KSTK_ESP(stack) ((stack)[1022])

#define       _SSIZE(stack)   (TASK_SIZE - KSTK_ESP(stack))
#define       SSIZE(stack)    (KSTK_ESP(stack) ? _SSIZE(stack) : 0)

#define       VSIZE(task,stack) (((task)->brk + 1023 + SSIZE(stack)) / 1024)
#define       SIZE(task,stack)  (((task)->brk - (task)->end_code + 1023 + \
                         SSIZE(stack)) / 1024)

typedef unsigned reg_t;

#if 0
union task_union {
  struct task_struct task;
  reg_t stack[PAGE_SIZE/4];
};
#endif


char *find_func();
unsigned long k_addr();
unsigned long get_kword();
char *cmd_args();
char *dev_to_tty();
char *wchan();
char *status();
char *xmalloc();
