/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.shaded.introspection.ReflectionValueExtractor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PropertyHelper;

class POMPropertyHelper
extends PropertyHelper {
    protected final Pom pom;
    private static final String PROPERTIES_PREFIX = "project.properties.";

    POMPropertyHelper(Pom pom) {
        this.pom = pom;
    }

    public Object getPropertyHook(String ns, String name, boolean user) {
        String prefix = this.pom.antId + ".";
        if (!name.startsWith(prefix)) {
            return super.getPropertyHook(ns, name, user);
        }
        try {
            String expression = name.substring(prefix.length());
            return this.getPOMValue("project." + expression);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Object getPOMValue(String expression) {
        Object value = null;
        try {
            if (expression.startsWith(PROPERTIES_PREFIX)) {
                expression = expression.substring(PROPERTIES_PREFIX.length());
                value = this.pom.getMavenProject().getProperties().get(expression);
            } else {
                value = ReflectionValueExtractor.evaluate(expression, this.pom.getMavenProject());
            }
        }
        catch (Exception e) {
            throw new BuildException("Error extracting expression from POM", (Throwable)e);
        }
        return value;
    }
}

