/*
 * Copyright 2002-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.web.context.request.async;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.context.request.ServletWebRequest;

/**
 * An {@code AsyncWebRequest} to use when there is no underlying async support.
 *
 * @author Rossen Stoyanchev
 * @since 3.2
 */
public class NoSupportAsyncWebRequest extends ServletWebRequest implements AsyncWebRequest {

	public NoSupportAsyncWebRequest(HttpServletRequest request, HttpServletResponse response) {
		super(request, response);
	}

	public void addCompletionHandler(Runnable runnable) {
		// ignored
	}

	public void setTimeout(Long timeout) {
		// ignored
	}

	public void addTimeoutHandler(Runnable runnable) {
		// ignored
	}

	public boolean isAsyncStarted() {
		return false;
	}

	// Not supported

	public void startAsync() {
		throw new UnsupportedOperationException("No async support in a pre-Servlet 3.0 runtime");
	}

	public boolean isAsyncComplete() {
		throw new UnsupportedOperationException("No async support in a pre-Servlet 3.0 runtime");
	}

	public void dispatch() {
		throw new UnsupportedOperationException("No async support in a pre-Servlet 3.0 runtime");
	}

}
