/*
** Copyright 1992
** Patrick Sweeney
*/
#ifndef define_TOKEN
#define define_TOKEN

#include <stdio.h>
#include "ll2.h"

typedef enum {
	TOKEN_COLON,
	TOKEN_LITERAL,
	TOKEN_INTEGER,
	TOKEN_PUNCT,
	TOKEN_END,
	TOKEN_EOF,
	TOKEN_PHONE1,
	TOKEN_PHONE2,
	TOKEN_TIMEOUT,
	TOKEN_RETRIES,
	TOKEN_SCRIPT,
	TOKEN_SYSTEM,
	TOKEN_BAUDRATE,
	TOKEN_DEVICE,
	TOKEN_MODEM,
	TOKEN_DIALSTR,
	TOKEN_RESETSTR,
	TOKEN_HANGUPSTR,
	TOKEN_STOPBITS,
	TOKEN_DATABITS,
	TOKEN_DIALER,
	TOKEN_REMOTE,
	TOKEN_LOCAL,
	TOKEN_WAIT,
	TOKEN_NOWAIT
} token_t;

#define MAX_TOKENLEN 80

typedef struct {
	token_t type;
	union {
		char sval[MAX_TOKENLEN];
		int ival;
		char cval;
	} v;
} Token;

typedef struct {
	char *fn;
	FILE *f;
	int linenum;
	Ll2 *syslist;
	Ll2 *modems;
} Tokenfile;

extern int token_read(Tokenfile *tf, Token *token);
extern int token_error(Tokenfile *tf, char *msg);

#endif /* define_TOKEN */
