# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.redhatopenshift.aio import AzureRedHatOpenShiftClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureRedHatOpenShiftOpenShiftClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureRedHatOpenShiftClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.open_shift_clusters.list(
            api_version="2023-11-22",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.open_shift_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-11-22",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.open_shift_clusters.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-11-22",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.open_shift_clusters.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={
                    "location": "str",
                    "apiserverProfile": {"ip": "str", "url": "str", "visibility": "str"},
                    "clusterProfile": {
                        "domain": "str",
                        "fipsValidatedModules": "str",
                        "pullSecret": "str",
                        "resourceGroupId": "str",
                        "version": "str",
                    },
                    "consoleProfile": {"url": "str"},
                    "id": "str",
                    "ingressProfiles": [{"ip": "str", "name": "str", "visibility": "str"}],
                    "masterProfile": {
                        "diskEncryptionSetId": "str",
                        "encryptionAtHost": "str",
                        "subnetId": "str",
                        "vmSize": "str",
                    },
                    "name": "str",
                    "networkProfile": {
                        "loadBalancerProfile": {
                            "effectiveOutboundIps": [{"id": "str"}],
                            "managedOutboundIps": {"count": 0},
                        },
                        "outboundType": "str",
                        "podCidr": "str",
                        "preconfiguredNSG": "str",
                        "serviceCidr": "str",
                    },
                    "provisioningState": "str",
                    "servicePrincipalProfile": {"clientId": "str", "clientSecret": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "workerProfiles": [
                        {
                            "count": 0,
                            "diskEncryptionSetId": "str",
                            "diskSizeGB": 0,
                            "encryptionAtHost": "str",
                            "name": "str",
                            "subnetId": "str",
                            "vmSize": "str",
                        }
                    ],
                    "workerProfilesStatus": [
                        {
                            "count": 0,
                            "diskEncryptionSetId": "str",
                            "diskSizeGB": 0,
                            "encryptionAtHost": "str",
                            "name": "str",
                            "subnetId": "str",
                            "vmSize": "str",
                        }
                    ],
                },
                api_version="2023-11-22",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.open_shift_clusters.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                api_version="2023-11-22",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.open_shift_clusters.begin_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={
                    "apiserverProfile": {"ip": "str", "url": "str", "visibility": "str"},
                    "clusterProfile": {
                        "domain": "str",
                        "fipsValidatedModules": "str",
                        "pullSecret": "str",
                        "resourceGroupId": "str",
                        "version": "str",
                    },
                    "consoleProfile": {"url": "str"},
                    "ingressProfiles": [{"ip": "str", "name": "str", "visibility": "str"}],
                    "masterProfile": {
                        "diskEncryptionSetId": "str",
                        "encryptionAtHost": "str",
                        "subnetId": "str",
                        "vmSize": "str",
                    },
                    "networkProfile": {
                        "loadBalancerProfile": {
                            "effectiveOutboundIps": [{"id": "str"}],
                            "managedOutboundIps": {"count": 0},
                        },
                        "outboundType": "str",
                        "podCidr": "str",
                        "preconfiguredNSG": "str",
                        "serviceCidr": "str",
                    },
                    "provisioningState": "str",
                    "servicePrincipalProfile": {"clientId": "str", "clientSecret": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "workerProfiles": [
                        {
                            "count": 0,
                            "diskEncryptionSetId": "str",
                            "diskSizeGB": 0,
                            "encryptionAtHost": "str",
                            "name": "str",
                            "subnetId": "str",
                            "vmSize": "str",
                        }
                    ],
                    "workerProfilesStatus": [
                        {
                            "count": 0,
                            "diskEncryptionSetId": "str",
                            "diskSizeGB": 0,
                            "encryptionAtHost": "str",
                            "name": "str",
                            "subnetId": "str",
                            "vmSize": "str",
                        }
                    ],
                },
                api_version="2023-11-22",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_admin_credentials(self, resource_group):
        response = await self.client.open_shift_clusters.list_admin_credentials(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-11-22",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_credentials(self, resource_group):
        response = await self.client.open_shift_clusters.list_credentials(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2023-11-22",
        )

        # please add some check logic here by yourself
        # ...
