# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import ContainerRegistryManagementClientConfiguration
from .operations import RegistriesOperations
from .operations import Operations
from .operations import ReplicationsOperations
from .operations import WebhooksOperations
from .operations import AgentPoolsOperations
from .operations import RunsOperations
from .operations import TaskRunsOperations
from .operations import TasksOperations
from .operations import ScopeMapsOperations
from .operations import TokensOperations
from .. import models


class ContainerRegistryManagementClient(object):
    """ContainerRegistryManagementClient.

    :ivar registries: RegistriesOperations operations
    :vartype registries: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.RegistriesOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.Operations
    :ivar replications: ReplicationsOperations operations
    :vartype replications: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.ReplicationsOperations
    :ivar webhooks: WebhooksOperations operations
    :vartype webhooks: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.WebhooksOperations
    :ivar agent_pools: AgentPoolsOperations operations
    :vartype agent_pools: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.AgentPoolsOperations
    :ivar runs: RunsOperations operations
    :vartype runs: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.RunsOperations
    :ivar task_runs: TaskRunsOperations operations
    :vartype task_runs: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.TaskRunsOperations
    :ivar tasks: TasksOperations operations
    :vartype tasks: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.TasksOperations
    :ivar scope_maps: ScopeMapsOperations operations
    :vartype scope_maps: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.ScopeMapsOperations
    :ivar tokens: TokensOperations operations
    :vartype tokens: azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.TokensOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Microsoft Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = ContainerRegistryManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.registries = RegistriesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.replications = ReplicationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.webhooks = WebhooksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.agent_pools = AgentPoolsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.runs = RunsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.task_runs = TaskRunsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.tasks = TasksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.scope_maps = ScopeMapsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.tokens = TokensOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "ContainerRegistryManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
