
      SUBROUTINE INITND 
C     -----------------
C     -----------------------------------------------------------------------
C     |       Initialise the processor numbers of the host and nodes        |
C     |  (which are stored in COMMON block /nodes/).   The process id's     |
C     |  (PID's) are initialised in block data (host = 0, node = 1).        |
C     |                                                                     |
C     |  In this program three dimensions of the lattice are distributed,   |
C     |  and the nodes are connected in a 3 dimensional array of size       |
C     |  (procx, procy, procz).  If the coordinates of a node in this       |
C     |  array are (X,Y,Z), then the mapping onto the linear node number is:|
C     |                                                                     |
C     |   nodenum = X + (procx * Y) + (procx * procy * Z)                   |
C     |                                                                     |
C     |       The following linear node numbers are stored in COMMON :      |
C     |                                                                     |
C     |  'thisnode', 'PosXnode', etc.                                       |
C     |     - this node and its neighbours in the  +/- x, y and z dirns.    |
C     |                                                                     |
C     |  'X0node', 'Y0node', 'Z0node'                                       |
C     |     - the nodes at (0,Y,Z), (X,0,Z) and (X,Y,0) respectively,       |
C     |       where this node is (X,Y,Z)                                    |
C     -----------------------------------------------------------------------
      INCLUDE 'qcd2.inc'

      INTEGER   MTASK, TASKND
      INTEGER   POSXND, POSYND, POSZND, NEGXND, NEGYND,
     *          NEGZND, X0NODE, Y0NODE, Z0NODE,  THISND
      COMMON / TASKS / MTASK, TASKND(0:PROCX-1, 0:PROCY-1, 0:PROCZ-1)
      COMMON / NODES /  POSXND, POSYND, POSZND,
     *                  NEGXND, NEGYND, NEGZND,
     *                  X0NODE,   Y0NODE,   Z0NODE,  THISND

      INTEGER SEED, INNODE 
      DOUBLE PRECISION N2
      LOGICAL  STORED   
      COMMON / RANDOM / N2, SEED, INNODE, STORED

      INTEGER  X, Y, Z, XP, YP, ZP, XM, YM, ZM


C------ Processor numbers of the host;  this node;  its neighbours in
C------ the +/- x, y and z dirns; and the 'edge' nodes (0,Y,Z), etc.

      X   =  MOD (INNODE, PROCX)
      Y   =  MOD ((INNODE / PROCX), PROCY)
      Z   =  INNODE / (PROCX * PROCY)

      XP  =  MOD ((X + 1), PROCX)
      YP  =  MOD ((Y + 1), PROCY)
      ZP  =  MOD ((Z + 1), PROCZ)
      XM  =  MOD ((X + PROCX - 1), PROCX)
      YM  =  MOD ((Y + PROCY - 1), PROCY)
      ZM  =  MOD ((Z + PROCZ - 1), PROCZ)

      POSXND  =  TASKND ( XP, Y,  Z  )
      POSYND  =  TASKND ( X,  YP, Z  )
      POSZND  =  TASKND ( X,  Y,  ZP )
      NEGXND  =  TASKND ( XM, Y,  Z  )
      NEGYND  =  TASKND ( X,  YM, Z  )
      NEGZND  =  TASKND ( X,  Y,  ZM )

      X0NODE  =  TASKND ( 0, Y, Z )
      Y0NODE  =  TASKND ( X, 0, Z )
      Z0NODE  =  TASKND ( X, Y, 0 )
      THISND  =  TASKND ( X, Y, Z )

      END

